/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.tamaya.spi.PropertyValueBuilder;

public final class PropertyValue {
    private String key;
    private Map<String, String> configEntries = new HashMap<String, String>();

    PropertyValue(PropertyValueBuilder builder) {
        this.key = builder.key;
        if (builder.contextData != null) {
            this.configEntries.putAll(builder.contextData);
        }
        this.configEntries.put(this.key, Objects.requireNonNull(builder.value));
    }

    private PropertyValue(String key, String value, String source) {
        this.key = Objects.requireNonNull(key, "key is required.");
        this.configEntries.put(key, value);
        this.configEntries.put("_" + key + ".source", Objects.requireNonNull(source, "source is required."));
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.configEntries.get(this.key);
    }

    public Map<String, String> getConfigEntries() {
        return Collections.unmodifiableMap(this.configEntries);
    }

    public static PropertyValueBuilder builder(String key, String value, String source) {
        return new PropertyValueBuilder(key, value, source);
    }

    public static PropertyValue of(String key, String value, String source) {
        if (value == null) {
            return null;
        }
        return new PropertyValue(key, value, source);
    }

    public String get(String key) {
        return this.configEntries.get(key);
    }
}

