/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.server.spi;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.ConfigOperator;
import org.apache.tamaya.server.spi.ScopeProvider;
import org.apache.tamaya.spi.ServiceContextManager;

public final class ScopeManager {
    private static final Logger LOG = Logger.getLogger(ScopeManager.class.getName());
    private static Map<String, ScopeProvider> scopeProviders = ScopeManager.initProviders();

    private static Map<String, ScopeProvider> initProviders() {
        ConcurrentHashMap<String, ScopeProvider> result = new ConcurrentHashMap<String, ScopeProvider>();
        for (ScopeProvider prov : ServiceContextManager.getServiceContext().getServices(ScopeProvider.class)) {
            try {
                result.put(prov.getScopeType(), prov);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Error loading scopes from " + prov, e);
            }
        }
        return result;
    }

    private ScopeManager() {
    }

    public static ConfigOperator getScope(String scopeId, String targetScope) throws ConfigException {
        ScopeProvider prov = scopeProviders.get(scopeId);
        if (prov == null) {
            throw new ConfigException("No such scope: " + scopeId);
        }
        return prov.getScope(targetScope);
    }

    public static Set<String> getScopes() {
        return scopeProviders.keySet();
    }
}

