/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class VersionProperties {
    private static final String VERSION_PROPERTY_FILE = "/META-INF/tamaya-server-version.properties";
    private static String product;
    private static String version;

    private VersionProperties() {
    }

    public static String getProduct() {
        return product;
    }

    public static String getVersion() {
        return version;
    }

    static {
        try (InputStream resource = VersionProperties.class.getResourceAsStream(VERSION_PROPERTY_FILE);){
            if (null == resource) {
                throw new ExceptionInInitializerError("Failed to version information resource. /META-INF/tamaya-server-version.properties not found.");
            }
            Properties properties = new Properties();
            properties.load(resource);
            product = properties.getProperty("server.product", "n/a");
            version = properties.getProperty("server.version", "n/a");
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

