/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.server;

import java.io.StringWriter;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import javax.json.stream.JsonGenerator;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.functions.ConfigurationFunctions;
import org.apache.tamaya.server.VersionProperties;

@Path(value="/")
@Produces(value={"application/json", "text/plain"})
public class ConfigurationResource {
    private final String scope;
    private final AtomicLong readCounter = new AtomicLong();
    private final AtomicLong writeCounter = new AtomicLong();
    private final AtomicLong deleteCounter = new AtomicLong();

    public ConfigurationResource(String scope) {
        this.scope = scope;
    }

    @GET
    @Path(value="/version")
    @Produces(value={"application/json", "text/plain"})
    public String version() {
        String product = VersionProperties.getProduct().replace("\"", "\\\"");
        String version = VersionProperties.getVersion().replace("\"", "\\\"");
        return String.format("{ \"version\" : \"%s: %s\" }", product, version);
    }

    @GET
    @Path(value="/v2/keys")
    public String readEtcdConfig(@QueryParam(value="recursive") Boolean recursive) {
        return this.readConfig(recursive);
    }

    @GET
    @Path(value="/keys")
    public String readConfig(@QueryParam(value="recursive") Boolean recursive) {
        this.readCounter.incrementAndGet();
        Configuration config = ConfigurationProvider.getConfiguration();
        Map<String, String> children = config.getProperties();
        JsonArrayBuilder ab = Json.createArrayBuilder();
        for (Map.Entry<String, String> en : children.entrySet()) {
            Node node = new Node(config, en.getKey(), "node");
            ab.add(node.createJsonObject());
        }
        Node node = new Node(config, null, "node", ab.build());
        JsonObjectBuilder root = Json.createObjectBuilder().add("action", "get").add("node", node.createJsonObject());
        StringWriter writer = new StringWriter();
        JsonWriter jwriter = Json.createWriter(writer);
        jwriter.writeObject(root.build());
        return writer.toString();
    }

    @GET
    @Path(value="/v2/keys/{key}")
    public String readEtcdConfig(@PathParam(value="key") String key, @QueryParam(value="recursive") Boolean recursive) {
        return this.readConfig(key, recursive);
    }

    @GET
    @Path(value="/keys/{key}")
    public String readConfig(@PathParam(value="key") String key, @QueryParam(value="recursive") Boolean recursive) {
        this.readCounter.incrementAndGet();
        Configuration config = ConfigurationProvider.getConfiguration();
        if (key != null) {
            if (key.startsWith("/")) {
                key = key.substring(1);
            }
            if (config.get(key) != null && !recursive.booleanValue()) {
                Node node = new Node(config, key, "node");
                JsonObjectBuilder root = Json.createObjectBuilder().add("action", "get").add("node", node.createJsonObject());
                StringWriter writer = new StringWriter();
                JsonGenerator gen = Json.createGenerator(writer);
                gen.write(root.build());
                return writer.toString();
            }
        }
        Map<String, String> children = null;
        children = key == null ? config.getProperties() : config.with(ConfigurationFunctions.section(key)).getProperties();
        JsonArrayBuilder ab = Json.createArrayBuilder();
        for (Map.Entry<String, String> en : children.entrySet()) {
            Node node = new Node(config, en.getKey(), "node");
            ab.add(node.createJsonObject());
        }
        Node node = new Node(config, key, "node", ab.build());
        JsonObjectBuilder root = Json.createObjectBuilder().add("action", "get").add("node", node.createJsonObject());
        StringWriter writer = new StringWriter();
        JsonWriter jwriter = Json.createWriter(writer);
        jwriter.writeObject(root.build());
        return writer.toString();
    }

    @PUT
    @Path(value="/v2/keys/{key}")
    public String writeEtcdConfig(@PathParam(value="key") String key, @FormParam(value="value") String value, @FormParam(value="ttl") Integer ttl) {
        return this.writeConfig(key, value, ttl);
    }

    @PUT
    @Path(value="/keys/{key}")
    public String writeConfig(@PathParam(value="key") String key, @FormParam(value="value") String value, @FormParam(value="ttl") Integer ttl) {
        this.writeCounter.incrementAndGet();
        Configuration config = ConfigurationProvider.getConfiguration();
        if (key.startsWith("/")) {
            key = key.substring(1);
        }
        Node prevNode = new Node(config, key, "prevNode");
        Node node = new Node(config, key, "node");
        JsonObjectBuilder root = Json.createObjectBuilder().add("action", "set").add("node", node.createJsonObject()).add("prevNode", prevNode.createJsonObject());
        StringWriter writer = new StringWriter();
        JsonWriter jwriter = Json.createWriter(writer);
        jwriter.writeObject(root.build());
        return writer.toString();
    }

    @DELETE
    @Path(value="/v2/keys/{key}")
    public String deleteEtcdConfig(@PathParam(value="key") String key) {
        return this.deleteConfig(key);
    }

    @DELETE
    @Path(value="/keys/{key}")
    public String deleteConfig(@PathParam(value="key") String key) {
        this.deleteCounter.incrementAndGet();
        Configuration config = ConfigurationProvider.getConfiguration();
        if (key.startsWith("/")) {
            key = key.substring(1);
        }
        Node prevNode = new Node(config, key, "prevNode");
        Node node = new Node(config, key, "node");
        JsonObjectBuilder root = Json.createObjectBuilder().add("action", "delete").add("node", node.createJsonObject()).add("prevNode", prevNode.createJsonObject());
        StringWriter writer = new StringWriter();
        JsonWriter jwriter = Json.createWriter(writer);
        jwriter.writeObject(root.build());
        return writer.toString();
    }

    public long getDeleteCounter() {
        return this.deleteCounter.get();
    }

    public long getReadCounter() {
        return this.readCounter.get();
    }

    public long getWriteCounter() {
        return this.writeCounter.get();
    }

    private static final class Node {
        private Integer createdIndex;
        private Integer modifiedIndex;
        private final String key;
        private String value;
        private final String nodeId;
        private Integer ttl;
        private String expiration;
        private final JsonArray nodes;

        Node(Configuration config, String key, String nodeId) {
            this(config, key, nodeId, null);
        }

        Node(Configuration config, String key, String nodeId, JsonArray nodes) {
            this.key = key;
            this.nodeId = Objects.requireNonNull(nodeId);
            if (key != null) {
                this.value = config.get(key);
                this.createdIndex = config.getOrDefault("_" + key + ".createdIndex", Integer.class, null);
                this.modifiedIndex = config.getOrDefault("_" + key + ".modifiedIndex", Integer.class, null);
                this.ttl = config.getOrDefault("_" + key + ".ttl", Integer.class, null);
                this.expiration = config.getOrDefault("_" + key + ".expiration", null);
            }
            this.nodes = nodes;
        }

        JsonObject createJsonObject() {
            JsonObjectBuilder nodeBuilder = Json.createObjectBuilder();
            if (this.key != null) {
                nodeBuilder.add("key", '/' + this.key);
            } else {
                nodeBuilder.add("dir", true);
            }
            if (this.value != null) {
                nodeBuilder.add("value", this.value);
            }
            if (this.createdIndex != null) {
                nodeBuilder.add("createdIndex", this.createdIndex);
            }
            if (this.modifiedIndex != null) {
                nodeBuilder.add("modifiedIndex", this.modifiedIndex);
            }
            if (this.ttl != null) {
                nodeBuilder.add("ttl", this.ttl);
            }
            if (this.expiration != null) {
                nodeBuilder.add("expiration", this.value);
            }
            if (this.nodes != null) {
                nodeBuilder.add("nodes", this.nodes);
            }
            return nodeBuilder.build();
        }
    }
}

