/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.resource.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import javax.annotation.Priority;
import org.apache.tamaya.resource.ResourceLocator;

@Priority(value=80)
public class FileResourceLocator
implements ResourceLocator {
    private static final Logger LOG = Logger.getLogger(FileResourceLocator.class.getName());

    @Override
    public Collection<URL> lookup(ClassLoader classLoader, String expression) {
        ArrayList<URL> resources = new ArrayList<URL>();
        try {
            File file = new File(expression);
            if (file.exists()) {
                resources.add(file.toURI().toURL());
            }
            return resources;
        }
        catch (IOException | RuntimeException e) {
            LOG.finest("Failed to load resource from file: " + expression);
            return Collections.emptySet();
        }
    }
}

