/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.resource.internal;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.tamaya.resource.internal.Locator;

public class FileCollector {
    public static final String FILE_PREFIX = "file:";
    private static final Logger LOG = Logger.getLogger(FileCollector.class.getName());

    private FileCollector() {
    }

    public static Collection<URL> collectFiles(String expression) {
        File file;
        expression = expression.replace("\\", "/");
        Locator locator = Locator.of(expression);
        ArrayList<URL> result = new ArrayList<URL>();
        String rootPath = locator.getRootPath();
        if (rootPath.startsWith(FILE_PREFIX)) {
            rootPath = rootPath.substring(FILE_PREFIX.length());
        }
        if ((file = new File(rootPath)).exists()) {
            List<String> subTokens = locator.getSubPathTokens();
            result.addAll(FileCollector.traverseAndSelectFromChildren(file, subTokens, 0));
        }
        return result;
    }

    static Collection<URL> traverseAndSelectFromChildren(File dir, List<String> subTokens, int tokenIndex) {
        ArrayList<URL> result;
        block5: {
            File[] files;
            String token;
            block6: {
                block4: {
                    if (tokenIndex >= subTokens.size() || dir.isFile() || !dir.isDirectory()) {
                        return Collections.emptyList();
                    }
                    result = new ArrayList<URL>();
                    token = subTokens.get(tokenIndex);
                    if (!token.equals("**")) break block4;
                    result.addAll(FileCollector.traverseAndSelectFromChildren(dir, FileCollector.getSubExpression(subTokens, tokenIndex + 1)));
                    break block5;
                }
                token = token.replace("*", ".*").replace("?", ".?");
                files = dir.listFiles();
                if (tokenIndex != subTokens.size() - 1) break block6;
                if (files == null) break block5;
                for (File f : files) {
                    if (!f.isFile() || !f.getName().matches(token)) continue;
                    result.add(FileCollector.getURL(f));
                }
                break block5;
            }
            if (files != null) {
                for (File f : files) {
                    if (!f.isDirectory() || !f.getName().matches(token)) continue;
                    result.addAll(FileCollector.traverseAndSelectFromChildren(f, subTokens, tokenIndex + 1));
                }
            }
        }
        return result;
    }

    static Collection<URL> traverseAndSelectFromChildren(File file, String expression) {
        ArrayList<URL> result = new ArrayList<URL>();
        File[] files = file.listFiles();
        if (files == null) {
            return result;
        }
        for (File childFile : files) {
            if (childFile.isFile()) {
                if (!childFile.getName().matches(expression)) continue;
                try {
                    result.add(FileCollector.getURL(childFile));
                }
                catch (Exception e) {
                    LOG.warning("File not convertible to URL: " + childFile);
                }
                continue;
            }
            if (!childFile.isDirectory()) continue;
            result.addAll(FileCollector.traverseAndSelectFromChildren(childFile, expression));
        }
        return result;
    }

    private static URL getURL(File file) {
        Objects.requireNonNull(file);
        try {
            return file.toURI().toURL();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create URL from file: " + file);
        }
    }

    private static String getSubExpression(List<String> subTokens, int startIndex) {
        StringBuilder b = new StringBuilder();
        for (int i = startIndex; i < subTokens.size(); ++i) {
            b.append(subTokens.get(i));
            b.append('/');
        }
        if (b.length() > 0) {
            b.setLength(b.length() - 1);
        }
        return b.toString().replaceAll("\\*", ".*").replaceAll("\\?", ".?");
    }
}

