/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.resource.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.resource.internal.FileCollector;
import org.apache.tamaya.resource.internal.Locator;
import org.apache.tamaya.resource.internal.VfsSupport;

public class ClasspathCollector {
    private static final String PROTOCOL_JAR = "jar";
    private static final String JAR_URL_SEPARATOR = "!/";
    private static final String PROTOCOL_ZIP = "zip";
    private static final String PROTOCOL_VFSZIP = "vfszip";
    private static final String PROTOCOL_WSJAR = "wsjar";
    private static final String PROTOCOL_CODE_SOURCE = "code-source";
    private static final Logger LOG = Logger.getLogger(ClasspathCollector.class.getName());
    public static final String CLASSPATH_PREFIX = "classpath:";
    private final ClassLoader classLoader;

    public ClasspathCollector(ClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader);
    }

    public Collection<URL> collectFiles(String expression) {
        if (expression.startsWith(CLASSPATH_PREFIX)) {
            expression = expression.substring(CLASSPATH_PREFIX.length());
        }
        if (expression.startsWith("/")) {
            expression = expression.substring(1);
        }
        Locator locator = Locator.of(expression);
        ArrayList<URL> result = new ArrayList<URL>();
        try {
            Enumeration<URL> rootResources = this.classLoader.getResources(locator.getRootPath());
            while (rootResources.hasMoreElements()) {
                URL resource = rootResources.nextElement();
                try {
                    if (this.isJarFile(resource)) {
                        result.addAll(this.doFindPathMatchingJarResources(resource, locator.getSubPath()));
                        continue;
                    }
                    if (resource.getProtocol().startsWith(PROTOCOL_VFSZIP)) {
                        result.addAll(ClasspathCollector.findMatchingVfsResources(resource, locator.getSubPath()));
                        continue;
                    }
                    result.addAll(FileCollector.traverseAndSelectFromChildren(this.getFile(resource), locator.getSubPathTokens(), 0));
                }
                catch (IOException | URISyntaxException e) {
                    LOG.log(Level.SEVERE, "Error locating resources for: " + expression, e);
                }
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.log(Level.SEVERE, "Error locating resources for: " + expression, e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<URL> doFindPathMatchingJarResources(URL rootDirResource, String subPattern) throws IOException, URISyntaxException {
        String rootEntryPath;
        String jarFileUrl;
        JarFile jarFile;
        boolean isFileExpression;
        subPattern = subPattern.replace("*", ".*").replace("?", ".?").replace(".*.*", ".*");
        URLConnection con = rootDirResource.toURI().toURL().openConnection();
        boolean newJarFile = false;
        boolean bl = isFileExpression = !subPattern.contains("/");
        if (con instanceof JarURLConnection) {
            JarURLConnection jarCon = (JarURLConnection)con;
            jarCon.setUseCaches(false);
            jarFile = jarCon.getJarFile();
            jarFileUrl = jarCon.getJarFileURL().toExternalForm();
            JarEntry jarEntry = jarCon.getJarEntry();
            rootEntryPath = jarEntry != null ? jarEntry.getName() : "";
        } else {
            int separatorIndex;
            String urlFile = rootDirResource.toURI().toURL().getFile();
            jarFileUrl = urlFile.substring(0, separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR));
            if (jarFileUrl.startsWith("file:")) {
                jarFileUrl = jarFileUrl.substring("file:".length());
            }
            jarFile = new JarFile(jarFileUrl);
            newJarFile = true;
            jarFileUrl = "file:" + jarFileUrl;
            rootEntryPath = urlFile.substring(separatorIndex + JAR_URL_SEPARATOR.length());
        }
        try {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Looking for matching resources in jar file [" + jarFileUrl + "]");
            }
            if (!rootEntryPath.isEmpty() && !rootEntryPath.endsWith("/")) {
                rootEntryPath = rootEntryPath + '/';
            }
            ArrayList<URL> result = new ArrayList<URL>(10);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String relativePath;
                JarEntry entry = entries.nextElement();
                String entryPath = entry.getName();
                if (!entryPath.startsWith(rootEntryPath) || (relativePath = entryPath.substring(rootEntryPath.length())).contains("/") && isFileExpression || !relativePath.matches(subPattern)) continue;
                result.add(this.createRelativeFrom(rootDirResource, relativePath));
            }
            ArrayList<URL> arrayList = result;
            return arrayList;
        }
        finally {
            if (newJarFile) {
                jarFile.close();
            }
        }
    }

    private URL createRelativeFrom(URL url, String relativePath) throws MalformedURLException {
        String rootDirResource = url.toExternalForm();
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        if (!rootDirResource.endsWith("/")) {
            rootDirResource = rootDirResource + '/';
        }
        return new URL(rootDirResource + relativePath);
    }

    private boolean isJarFile(URL url) {
        String protocol = Objects.requireNonNull(url).getProtocol();
        return PROTOCOL_JAR.equals(protocol) || PROTOCOL_ZIP.equals(protocol) || PROTOCOL_VFSZIP.equals(protocol) || PROTOCOL_WSJAR.equals(protocol) || PROTOCOL_CODE_SOURCE.equals(protocol) && url.getPath().contains(JAR_URL_SEPARATOR);
    }

    private File getFile(URL resourceUrl) {
        Objects.requireNonNull(resourceUrl, "Resource URL must not be null");
        if (!"file".equals(resourceUrl.getProtocol())) {
            return null;
        }
        try {
            return new File(resourceUrl.toURI().getSchemeSpecificPart());
        }
        catch (Exception ex) {
            return new File(resourceUrl.getFile());
        }
    }

    private static Collection<URL> findMatchingVfsResources(URL rootResource, String locationPattern) throws IOException {
        Object root = VfsSupport.getRoot(rootResource);
        PatternVfsVisitor visitor = new PatternVfsVisitor(VfsSupport.getPath(root), locationPattern);
        VfsSupport.visit(root, visitor);
        return visitor.getResources();
    }

    private static class PatternVfsVisitor
    implements InvocationHandler {
        private final String subPattern;
        private final String rootPath;
        private final List<URL> resources = new LinkedList<URL>();

        public PatternVfsVisitor(String rootPath, String subPattern) {
            this.subPattern = subPattern;
            this.rootPath = rootPath.length() == 0 || rootPath.endsWith("/") ? rootPath : rootPath + "/";
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (Object.class.equals(method.getDeclaringClass())) {
                if (methodName.equals("equals")) {
                    return proxy == args[0];
                }
                if (methodName.equals("hashCode")) {
                    return System.identityHashCode(proxy);
                }
            } else {
                if ("getAttributes".equals(methodName)) {
                    return VfsSupport.getVisitorAttributes();
                }
                if ("visit".equals(methodName)) {
                    this.visit(args[0]);
                    return null;
                }
                if ("toString".equals(methodName)) {
                    return this.toString();
                }
            }
            throw new IllegalStateException("Unexpected method invocation: " + method);
        }

        public void visit(Object vfsResource) {
            String subPath = VfsSupport.getPath(vfsResource).substring(this.rootPath.length());
            if (subPath.matches(this.subPattern)) {
                try {
                    this.resources.add(VfsSupport.getURL(vfsResource));
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Failed to convert vfs resource to URL: " + vfsResource, e);
                }
            }
        }

        public Collection<URL> getResources() {
            return this.resources;
        }

        public String toString() {
            return "sub-pattern: " + this.subPattern + ", resources: " + this.resources;
        }
    }
}

