/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.json;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.apache.tamaya.ConfigException;

class JSONVisitor {
    private final JsonObject rootNode;
    private final Map<String, String> targetStore;

    JSONVisitor(JsonObject startNode, Map<String, String> target) {
        this.rootNode = startNode;
        this.targetStore = target;
    }

    public void run() {
        ArrayDeque<VisitingContext> stack = new ArrayDeque<VisitingContext>();
        stack.add(new VisitingContext(this.rootNode));
        boolean goOn = ((VisitingContext)stack.peek()).hasNext();
        if (goOn) {
            do {
                String key;
                Map.Entry<String, JsonValue> current;
                if (!((current = ((VisitingContext)stack.peek()).nextElement()).getValue() instanceof JsonStructure)) {
                    String value;
                    key = ((VisitingContext)stack.peek()).getNSPrefix() + current.getKey();
                    JsonValue jsonValue = current.getValue();
                    switch (jsonValue.getValueType()) {
                        case NULL: {
                            value = null;
                            break;
                        }
                        case FALSE: {
                            value = Boolean.FALSE.toString();
                            break;
                        }
                        case TRUE: {
                            value = Boolean.TRUE.toString();
                            break;
                        }
                        case NUMBER: {
                            value = jsonValue.toString();
                            break;
                        }
                        case STRING: {
                            value = ((JsonString)jsonValue).getString();
                            break;
                        }
                        default: {
                            throw new ConfigException("Internal failure while processing JSON document.");
                        }
                    }
                    this.targetStore.put(key, value);
                } else if (current.getValue() instanceof JsonObject) {
                    key = ((VisitingContext)stack.peek()).getNSPrefix() + current.getKey();
                    JsonObject node = (JsonObject)current.getValue();
                    stack.push(new VisitingContext(node, key));
                } else {
                    if (current.getValue() instanceof JsonArray) {
                        throw new ConfigException("Arrays are not supported at the moment.");
                    }
                    throw new ConfigException("Internal failure while processing JSON document.");
                }
                goOn = ((VisitingContext)stack.peek()).hasNext();
                while (!goOn && stack.size() > 0) {
                    stack.remove();
                    goOn = stack.size() > 0 && ((VisitingContext)stack.peek()).hasNext();
                }
            } while (goOn);
        }
    }

    private static class VisitingContext {
        private final String namespace;
        private final JsonObject node;
        private final Iterator<Map.Entry<String, JsonValue>> elements;

        public VisitingContext(JsonObject node) {
            this(node, "");
        }

        public VisitingContext(JsonObject rootNode, String currentNamespace) {
            this.namespace = currentNamespace;
            this.node = rootNode;
            this.elements = this.node.entrySet().iterator();
        }

        public Map.Entry<String, JsonValue> nextElement() {
            return this.elements.next();
        }

        public boolean hasNext() {
            return this.elements.hasNext();
        }

        public String getNSPrefix() {
            return this.namespace.isEmpty() ? this.namespace : this.namespace + ".";
        }
    }
}

