/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.functions;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.tamaya.functions.PropertyMapper;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValue;

class ValueMappedPropertySource
implements PropertySource {
    private final String name;
    private final PropertyMapper valueFilter;
    private final PropertySource source;

    public ValueMappedPropertySource(String name, PropertyMapper valueFilter, PropertySource current) {
        this.name = name != null ? name : "<valueFiltered> -> name=" + current.getName() + ", valueFilter=" + valueFilter.toString();
        this.valueFilter = valueFilter;
        this.source = Objects.requireNonNull(current);
    }

    @Override
    public int getOrdinal() {
        return this.source.getOrdinal();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PropertyValue get(String key) {
        PropertyValue value = this.source.get(key);
        if (value != null) {
            return PropertyValue.of(key, this.valueFilter.mapProperty(key, value.getValue()), this.getName());
        }
        return null;
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.source.getProperties().entrySet()) {
            map.put(entry.getKey(), this.valueFilter.mapProperty(entry.getKey(), entry.getValue()));
        }
        return map;
    }

    @Override
    public boolean isScannable() {
        return this.source.isScannable();
    }

    public String toString() {
        return "ValueMappedPropertySource{source=" + this.source.getName() + ", name='" + this.name + '\'' + ", valueFilter=" + this.valueFilter + '}';
    }
}

