/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.functions;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.tamaya.functions.KeyMapper;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValue;

class MappedPropertySource
implements PropertySource {
    private static final long serialVersionUID = 8690637705511432083L;
    private final KeyMapper keyMapper;
    private final PropertySource propertySource;

    public MappedPropertySource(PropertySource config, KeyMapper keyMapper) {
        this.propertySource = Objects.requireNonNull(config);
        this.keyMapper = Objects.requireNonNull(keyMapper);
    }

    @Override
    public int getOrdinal() {
        return this.propertySource.getOrdinal();
    }

    @Override
    public String getName() {
        return this.propertySource.getName() + "[mapped]";
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, String> map = this.propertySource.getProperties();
        for (Map.Entry<String, String> en : map.entrySet()) {
            String targetKey = this.keyMapper.mapKey(en.getKey());
            if (targetKey == null) continue;
            result.put(targetKey, en.getValue());
        }
        return result;
    }

    @Override
    public boolean isScannable() {
        return this.propertySource.isScannable();
    }

    @Override
    public PropertyValue get(String key) {
        return PropertyValue.of(key, this.getProperties().get(key), this.getName());
    }
}

