/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.functions;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigOperator;
import org.apache.tamaya.ConfigQuery;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.functions.KeyMapper;
import org.apache.tamaya.spi.ConfigurationContext;

class MappedConfiguration
implements Configuration {
    private static final Logger LOG = Logger.getLogger(MappedConfiguration.class.getName());
    private final Configuration baseConfiguration;
    private final KeyMapper keyMapper;
    private final String mapType;

    MappedConfiguration(Configuration baseConfiguration, KeyMapper keyMapper, String mapType) {
        this.baseConfiguration = Objects.requireNonNull(baseConfiguration);
        this.keyMapper = Objects.requireNonNull(keyMapper);
        this.mapType = mapType != null ? mapType : this.keyMapper.toString();
    }

    @Override
    public String get(String key) {
        return this.get(key, String.class);
    }

    @Override
    public String getOrDefault(String key, String defaultValue) {
        String val = this.get(key);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    @Override
    public <T> T getOrDefault(String key, Class<T> type, T defaultValue) {
        T val = this.get(key, type);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    @Override
    public <T> T get(String key, Class<T> type) {
        return (T)this.get(key, TypeLiteral.of(type));
    }

    @Override
    public <T> T get(String key, TypeLiteral<T> type) {
        String targetKey = this.keyMapper.mapKey(key);
        if (targetKey != null) {
            return this.baseConfiguration.get(targetKey, type);
        }
        LOG.finest("Configuration property hidden by KeyMapper, key=" + key + ", mapper=" + this.keyMapper + ", config=" + this);
        return null;
    }

    @Override
    public <T> T getOrDefault(String key, TypeLiteral<T> type, T defaultValue) {
        T val = this.get(key, type);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> baseProps = this.baseConfiguration.getProperties();
        HashMap<String, String> props = new HashMap<String, String>(baseProps.size());
        for (Map.Entry<String, String> en : baseProps.entrySet()) {
            String targetKey = this.keyMapper.mapKey(en.getKey());
            if (targetKey == null) continue;
            props.put(targetKey, en.getValue());
        }
        return props;
    }

    @Override
    public Configuration with(ConfigOperator operator) {
        return operator.operate(this);
    }

    @Override
    public <T> T query(ConfigQuery<T> query) {
        return query.query(this);
    }

    @Override
    public ConfigurationContext getContext() {
        return this.baseConfiguration.getContext();
    }

    public String toString() {
        return "FilteredConfiguration{baseConfiguration=" + this.baseConfiguration + ", mapping=" + this.mapType + '}';
    }
}

