/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.functions;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.tamaya.functions.Predicate;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValue;

class FilteredPropertySource
implements PropertySource {
    private final PropertySource baseSource;
    private final Predicate<String> filter;

    public FilteredPropertySource(PropertySource baseSource, Predicate<String> filter) {
        this.baseSource = Objects.requireNonNull(baseSource);
        this.filter = Objects.requireNonNull(filter);
    }

    @Override
    public int getOrdinal() {
        return this.baseSource.getOrdinal();
    }

    @Override
    public String getName() {
        return this.baseSource.getName();
    }

    @Override
    public PropertyValue get(String key) {
        return PropertyValue.of(key, this.getProperties().get(key), this.getName());
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> en : this.baseSource.getProperties().entrySet()) {
            if (!this.filter.test(en.getKey())) continue;
            result.put(en.getKey(), en.getValue());
        }
        return result;
    }

    @Override
    public boolean isScannable() {
        return this.baseSource.isScannable();
    }

    public String toString() {
        return "FilteredPropertySource{baseSource=" + this.baseSource + ", filter=" + this.filter + '}';
    }
}

