/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.functions;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValue;

class EnrichedPropertySource
implements PropertySource {
    private final PropertySource basePropertySource;
    private final Map<String, String> addedProperties;
    private final boolean overriding;

    EnrichedPropertySource(PropertySource propertySource, Map<String, String> properties, boolean overriding) {
        this.basePropertySource = Objects.requireNonNull(propertySource);
        this.addedProperties = Objects.requireNonNull(properties);
        this.overriding = overriding;
    }

    @Override
    public int getOrdinal() {
        return this.basePropertySource.getOrdinal();
    }

    @Override
    public String getName() {
        return this.basePropertySource.getName();
    }

    @Override
    public PropertyValue get(String key) {
        if (this.overriding) {
            String val = this.addedProperties.get(key);
            if (val != null) {
                return PropertyValue.of(key, val, this.getName());
            }
            return this.basePropertySource.get(key);
        }
        PropertyValue val = this.basePropertySource.get(key);
        if (val != null) {
            return val;
        }
        return PropertyValue.of(key, this.addedProperties.get(key), this.getName());
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> allProps;
        if (this.overriding) {
            allProps = new HashMap<String, String>(this.basePropertySource.getProperties());
            allProps.putAll(this.addedProperties);
        } else {
            allProps = new HashMap<String, String>(this.addedProperties);
            allProps.putAll(this.basePropertySource.getProperties());
        }
        return allProps;
    }

    @Override
    public boolean isScannable() {
        return this.basePropertySource.isScannable();
    }
}

