/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.functions;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.tamaya.ConfigOperator;
import org.apache.tamaya.ConfigQuery;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.spi.ConfigurationContext;

class EnrichedConfiguration
implements Configuration {
    private final Configuration baseConfiguration;
    private final Map<String, Object> addedProperties = new HashMap<String, Object>();
    private final boolean overriding;

    EnrichedConfiguration(Configuration configuration, Map<String, Object> properties, boolean overriding) {
        this.baseConfiguration = Objects.requireNonNull(configuration);
        this.addedProperties.putAll(this.addedProperties);
        this.overriding = overriding;
    }

    @Override
    public String get(String key) {
        if (this.overriding) {
            Object val = this.addedProperties.get(key);
            if (val != null) {
                return val.toString();
            }
            return this.baseConfiguration.get(key);
        }
        String val = this.baseConfiguration.get(key);
        if (val != null) {
            return val;
        }
        Object val2 = this.addedProperties.get(key);
        if (val2 != null) {
            return val2.toString();
        }
        return null;
    }

    @Override
    public String getOrDefault(String key, String defaultValue) {
        String val = this.get(key);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    @Override
    public <T> T getOrDefault(String key, Class<T> type, T defaultValue) {
        T val = this.get(key, type);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    @Override
    public <T> T get(String key, Class<T> type) {
        return (T)this.get(key, TypeLiteral.of(type));
    }

    @Override
    public <T> T get(String key, TypeLiteral<T> type) {
        if (this.overriding) {
            Object val = this.addedProperties.get(key);
            if (val != null && type.getRawType().isAssignableFrom(val.getClass())) {
                return (T)val;
            }
            return this.baseConfiguration.get(key, type);
        }
        T val = this.baseConfiguration.get(key, type);
        if (val != null) {
            return val;
        }
        Object val2 = this.addedProperties.get(key);
        if (val2 != null && type.getRawType().isAssignableFrom(val2.getClass())) {
            return (T)val2;
        }
        return null;
    }

    @Override
    public <T> T getOrDefault(String key, TypeLiteral<T> type, T defaultValue) {
        T val = this.get(key, type);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> allProps = new HashMap<String, String>();
        if (this.overriding) {
            allProps.putAll(this.baseConfiguration.getProperties());
            for (Map.Entry<String, Object> en : this.addedProperties.entrySet()) {
                allProps.put(en.getKey(), en.getValue().toString());
            }
        } else {
            for (Map.Entry<String, Object> en : this.addedProperties.entrySet()) {
                allProps.put(en.getKey(), en.getValue().toString());
            }
            allProps.putAll(this.baseConfiguration.getProperties());
        }
        return allProps;
    }

    @Override
    public Configuration with(ConfigOperator operator) {
        return operator.operate(this);
    }

    @Override
    public <T> T query(ConfigQuery<T> query) {
        return query.query(this);
    }

    @Override
    public ConfigurationContext getContext() {
        return this.baseConfiguration.getContext();
    }
}

