/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.functions;

import java.util.Map;
import java.util.Objects;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValue;

final class ConfigWrappingPropertySource
implements PropertySource {
    private final String name;
    private final int ordinal;
    private final Configuration config;

    public ConfigWrappingPropertySource(String name, int ordinal, Configuration config) {
        this.name = Objects.requireNonNull(name);
        this.ordinal = ordinal;
        this.config = Objects.requireNonNull(config);
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PropertyValue get(String key) {
        return PropertyValue.of(key, this.config.get(key), this.getName());
    }

    @Override
    public Map<String, String> getProperties() {
        return this.config.getProperties();
    }

    @Override
    public boolean isScannable() {
        return true;
    }

    public String toString() {
        return "ConfigWrappingPropertySource(name=" + this.name + ", ordinal=" + this.ordinal + ", config=" + this.config + ")";
    }
}

