/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.functions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.tamaya.ConfigOperator;
import org.apache.tamaya.ConfigQuery;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.spi.ConfigurationContext;

class CombinedConfiguration
implements Configuration {
    private final String name;
    private final Configuration[] configurations;

    public CombinedConfiguration(String configName, Configuration ... configs) {
        this.name = configName;
        this.configurations = (Configuration[])configs.clone();
    }

    @Override
    public String get(String key) {
        String curValue = null;
        for (Configuration config : this.configurations) {
            String value = config.get(key);
            if (value == null) continue;
            curValue = value;
        }
        return curValue;
    }

    @Override
    public String getOrDefault(String key, String defaultValue) {
        String val = this.get(key);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    @Override
    public <T> T getOrDefault(String key, Class<T> type, T defaultValue) {
        T val = this.get(key, type);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    @Override
    public <T> T get(String key, Class<T> type) {
        T curValue = null;
        for (Configuration config : this.configurations) {
            T value = config.get(key, type);
            if (value == null) continue;
            curValue = value;
        }
        return curValue;
    }

    @Override
    public <T> T get(String key, TypeLiteral<T> type) {
        T curValue = null;
        for (Configuration config : this.configurations) {
            T value = config.get(key, type);
            if (value == null) continue;
            curValue = value;
        }
        return curValue;
    }

    @Override
    public <T> T getOrDefault(String key, TypeLiteral<T> type, T defaultValue) {
        T val = this.get(key, type);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Configuration ps : this.configurations) {
            result.putAll(ps.getProperties());
        }
        return result;
    }

    @Override
    public Configuration with(ConfigOperator operator) {
        return operator.operate(this);
    }

    @Override
    public <T> T query(ConfigQuery<T> query) {
        return query.query(this);
    }

    @Override
    public ConfigurationContext getContext() {
        return this.configurations[0].getContext();
    }

    public String toString() {
        return "CombinedConfiguration{name='" + this.name + '\'' + ", configurations=" + Arrays.toString(this.configurations) + '}';
    }
}

