/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.propertysource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValue;

public class SystemPropertySource
implements PropertySource {
    public static final int DEFAULT_ORDINAL = 1000;
    private volatile Map<String, String> cachedProperties;
    private int previousHash;
    private final boolean disabled = this.evaluateDisabled();

    private boolean evaluateDisabled() {
        String value = System.getProperty("tamaya.sysprops.disable");
        if (value == null) {
            value = System.getenv("tamaya.sysprops.disable");
        }
        if (value == null) {
            value = System.getProperty("tamaya.defaults.disable");
        }
        if (value == null) {
            value = System.getenv("tamaya.defaults.disable");
        }
        if (value == null) {
            return false;
        }
        return value.isEmpty() || Boolean.parseBoolean(value);
    }

    public SystemPropertySource() {
        this.cachedProperties = this.loadProperties();
        this.previousHash = System.getProperties().hashCode();
    }

    private Map<String, String> loadProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        Properties sysProps = System.getProperties();
        for (String name : sysProps.stringPropertyNames()) {
            props.put(name, sysProps.getProperty(name));
            props.put("_" + name + ".source", this.getName());
        }
        return props;
    }

    @Override
    public int getOrdinal() {
        return 1000;
    }

    @Override
    public String getName() {
        if (this.disabled) {
            return "system-properties(disabled)";
        }
        return "system-properties";
    }

    @Override
    public PropertyValue get(String key) {
        if (this.disabled) {
            return null;
        }
        return PropertyValue.of(key, System.getProperty(key), this.getName());
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.disabled) {
            return Collections.emptyMap();
        }
        if (this.previousHash != System.getProperties().hashCode()) {
            Map<String, String> properties = this.loadProperties();
            this.cachedProperties = Collections.unmodifiableMap(properties);
            this.previousHash = System.getProperties().hashCode();
        }
        return this.cachedProperties;
    }

    @Override
    public boolean isScannable() {
        return true;
    }
}

