/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.propertysource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.core.propertysource.BasePropertySource;

public class SimplePropertySource
extends BasePropertySource {
    private static final Logger LOG = Logger.getLogger(SimplePropertySource.class.getName());
    private String name;
    private Map<String, String> properties;

    public SimplePropertySource(File propertiesLocation) {
        super(0);
        try {
            this.name = propertiesLocation.toString();
            this.properties = this.load(propertiesLocation.toURI().toURL());
        }
        catch (IOException e) {
            throw new ConfigException("Failed to load properties from " + propertiesLocation, e);
        }
    }

    public SimplePropertySource(URL propertiesLocation) {
        super(0);
        this.properties = this.load(propertiesLocation);
        this.name = propertiesLocation.toString();
    }

    public SimplePropertySource(String name, Map<String, String> properties) {
        super(0);
        this.properties = new HashMap<String, String>(properties);
        this.name = Objects.requireNonNull(name);
    }

    public SimplePropertySource(String name, URL propertiesLocation) {
        super(0);
        this.properties = this.load(propertiesLocation);
        this.name = Objects.requireNonNull(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    private Map<String, String> load(URL propertiesFile) {
        HashMap<String, String> properties = new HashMap<String, String>();
        try (InputStream stream = propertiesFile.openStream();){
            Properties props = new Properties();
            if (stream != null) {
                props.load(stream);
            }
            for (String key : props.stringPropertyNames()) {
                properties.put(key, props.getProperty(key));
                if (this.getName() == null) {
                    LOG.warning("No Property Source name found for " + this + ", ommitting source meta-entries.");
                    continue;
                }
                properties.put("_" + key + ".source", this.getName());
            }
        }
        catch (IOException e) {
            throw new ConfigException("Error loading properties " + propertiesFile, e);
        }
        return properties;
    }
}

