/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.propertysource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValue;

public class EnvironmentPropertySource
implements PropertySource {
    private static final Logger LOG = Logger.getLogger(EnvironmentPropertySource.class.getName());
    public static final int DEFAULT_ORDINAL = 300;
    private final boolean disabled = this.evaluateDisabled();

    private boolean evaluateDisabled() {
        String value = System.getProperty("tamaya.envprops.disable");
        if (value == null) {
            value = System.getenv("tamaya.envprops.disable");
        }
        if (value == null) {
            value = System.getProperty("tamaya.defaults.disable");
        }
        if (value == null) {
            value = System.getenv("tamaya.defaults.disable");
        }
        if (value == null) {
            return false;
        }
        return value.isEmpty() || Boolean.parseBoolean(value);
    }

    @Override
    public int getOrdinal() {
        return 300;
    }

    @Override
    public String getName() {
        if (this.disabled) {
            return "environment-properties(disabled)";
        }
        return "environment-properties";
    }

    @Override
    public PropertyValue get(String key) {
        if (this.disabled) {
            return null;
        }
        return PropertyValue.of(key, System.getenv(key), this.getName());
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.disabled) {
            return Collections.emptyMap();
        }
        HashMap<String, String> entries = new HashMap<String, String>(System.getenv());
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            entries.put("_" + entry.getKey() + ".source", this.getName());
        }
        return entries;
    }

    @Override
    public boolean isScannable() {
        return true;
    }
}

