/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal.converters;

import java.net.URI;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;

public class URIConverter
implements PropertyConverter<URI> {
    private final Logger LOG = Logger.getLogger(this.getClass().getName());

    @Override
    public URI convert(String value, ConversionContext context) {
        context.addSupportedFormats(this.getClass(), "<uri> -> new URI(uri)");
        String trimmed = Objects.requireNonNull(value).trim();
        try {
            return new URI(trimmed);
        }
        catch (Exception e) {
            this.LOG.log(Level.FINE, "Unparseable URI: " + trimmed, e);
            return null;
        }
    }
}

