/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal.converters;

import java.util.Locale;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;

public class LongConverter
implements PropertyConverter<Long> {
    private static final Logger LOGGER = Logger.getLogger(LongConverter.class.getName());

    @Override
    public Long convert(String value, ConversionContext context) {
        context.addSupportedFormats(this.getClass(), "<long>", "MIN", "MIN_VALUE", "MAX", "MAX_VALUE");
        String trimmed = Objects.requireNonNull(value).trim();
        switch (trimmed.toUpperCase(Locale.ENGLISH)) {
            case "MIN_VALUE": 
            case "MIN": {
                return Long.MIN_VALUE;
            }
            case "MAX_VALUE": 
            case "MAX": {
                return Long.MAX_VALUE;
            }
        }
        try {
            return Long.decode(trimmed);
        }
        catch (Exception e) {
            LOGGER.finest("Unable to parse Long value: " + value);
            return null;
        }
    }
}

