/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal.converters;

import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;

public class ByteConverter
implements PropertyConverter<Byte> {
    private final Logger LOG = Logger.getLogger(this.getClass().getName());

    @Override
    public Byte convert(String value, ConversionContext context) {
        context.addSupportedFormats(this.getClass(), "<byte>", "MIN_VALUE", "MIN", "MAX_VALUE", "MAX");
        String trimmed = Objects.requireNonNull(value).trim();
        switch (trimmed.toUpperCase(Locale.ENGLISH)) {
            case "MIN_VALUE": 
            case "MIN": {
                return (byte)-128;
            }
            case "MAX_VALUE": 
            case "MAX": {
                return (byte)127;
            }
        }
        try {
            return Byte.decode(trimmed);
        }
        catch (Exception e) {
            this.LOG.log(Level.FINEST, "Unparseable Byte: " + value);
            return null;
        }
    }
}

