/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal.converters;

import java.util.Locale;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;

public class BooleanConverter
implements PropertyConverter<Boolean> {
    private final Logger LOG = Logger.getLogger(this.getClass().getName());

    @Override
    public Boolean convert(String value, ConversionContext context) {
        String ignoreCaseValue;
        context.addSupportedFormats(this.getClass(), "yes (ignore case)", "y (ignore case)", "true (ignore case)", "t (ignore case)", "no (ignore case)", "n (ignore case)", "false (ignore case)", "f (ignore case)");
        switch (ignoreCaseValue = Objects.requireNonNull(value).trim().toLowerCase(Locale.ENGLISH)) {
            case "yes": 
            case "y": 
            case "true": 
            case "t": {
                return Boolean.TRUE;
            }
            case "no": 
            case "n": 
            case "false": 
            case "f": {
                return Boolean.FALSE;
            }
        }
        this.LOG.finest("Unknown boolean value encountered: " + value);
        return null;
    }
}

