/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.FilterContext;
import org.apache.tamaya.spi.PropertyFilter;

public final class PropertyFiltering {
    private static final Logger LOG = Logger.getLogger(PropertyFiltering.class.getName());
    private static final int MAX_FILTER_LOOPS = 10;

    private PropertyFiltering() {
    }

    public static String applyFilter(String key, Map<String, String> configData, ConfigurationContext configurationContext) {
        String result = configData.get(key);
        for (int i = 0; i < 10; ++i) {
            boolean changed = false;
            FilterContext filterContext = new FilterContext(key, configData, false);
            for (PropertyFilter filter : configurationContext.getPropertyFilters()) {
                String newValue = filter.filterProperty(result, filterContext);
                if (newValue != null && !newValue.equals(result)) {
                    changed = true;
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Filter - " + key + ": " + result + " -> " + newValue + " by " + filter);
                    }
                } else if (result != null && !result.equals(newValue)) {
                    changed = true;
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Filter - " + key + ": " + result + " -> " + newValue + " by " + filter);
                    }
                }
                result = newValue;
            }
            if (!changed) {
                LOG.finest("Finishing filter loop, no changes detected.");
                break;
            }
            if (i == 9) {
                if (!LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Maximal filter loop count reached, aborting filter evaluation after cycles: " + i);
                continue;
            }
            LOG.finest("Repeating filter loop, changes detected.");
        }
        return result;
    }

    public static Map<String, String> applyFilters(Map<String, String> inputMap, ConfigurationContext configurationContext) {
        HashMap<String, String> resultMap = new HashMap<String, String>(inputMap);
        Map<String, String> metaData = PropertyFiltering.filterMetadata(inputMap);
        for (int i = 0; i < 10; ++i) {
            AtomicInteger changes = new AtomicInteger();
            for (Map.Entry<String, String> entry : inputMap.entrySet()) {
                FilterContext filterContext = new FilterContext(entry.getKey(), inputMap, true);
                for (PropertyFilter filter : configurationContext.getPropertyFilters()) {
                    String k = entry.getKey();
                    String v = entry.getValue();
                    String newValue = filter.filterProperty(v, filterContext);
                    if (newValue != null && !newValue.equals(v)) {
                        changes.incrementAndGet();
                        LOG.finest("Filter - " + k + ": " + v + " -> " + newValue + " by " + filter);
                    } else if (v != null && !v.equals(newValue)) {
                        changes.incrementAndGet();
                        LOG.finest("Filter - " + k + ": " + v + " -> " + newValue + " by " + filter);
                    }
                    if (null != newValue) {
                        resultMap.put(k, newValue);
                        continue;
                    }
                    resultMap.remove(k);
                }
            }
            if (changes.get() == 0) {
                LOG.finest("Finishing filter loop, no changes detected.");
                break;
            }
            if (i == 9) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Maximal filter loop count reached, aborting filter evaluation after cycles: " + i);
                }
            } else {
                LOG.finest("Repeating filter loop, changes detected: " + changes.get());
            }
            changes.set(0);
        }
        return resultMap;
    }

    private static Map<String, String> filterMetadata(Map<String, String> inputMap) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> en : inputMap.entrySet()) {
            if (!en.getKey().startsWith("_")) continue;
            result.put(en.getKey(), en.getValue());
        }
        return Collections.unmodifiableMap(result);
    }
}

