/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.core.internal.DefaultServiceContext;
import org.apache.tamaya.core.internal.converters.EnumConverter;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;
import org.apache.tamaya.spi.ServiceContextManager;

public class PropertyConverterManager {
    private static final Logger LOG = Logger.getLogger(PropertyConverterManager.class.getName());
    private final Map<TypeLiteral<?>, List<PropertyConverter<?>>> converters = new ConcurrentHashMap();
    private final Map<TypeLiteral<?>, List<PropertyConverter<?>>> transitiveConverters = new ConcurrentHashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final Comparator<Object> PRIORITY_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            int prio = DefaultServiceContext.getPriority(o1) - DefaultServiceContext.getPriority(o2);
            if (prio < 0) {
                return 1;
            }
            if (prio > 0) {
                return -1;
            }
            return o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName());
        }
    };

    public PropertyConverterManager() {
        this(true);
    }

    public PropertyConverterManager(boolean init) {
        if (init) {
            this.initConverters();
        }
    }

    protected void initConverters() {
        for (PropertyConverter conv : ServiceContextManager.getServiceContext().getServices(PropertyConverter.class)) {
            Type type = TypeLiteral.getGenericInterfaceTypeParameters(conv.getClass(), PropertyConverter.class)[0];
            this.register(TypeLiteral.of(type), conv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void register(TypeLiteral<T> targetType, PropertyConverter<T> converter) {
        Objects.requireNonNull(converter);
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            List converters = (List)List.class.cast(this.converters.get(targetType));
            ArrayList<PropertyConverter<T>> newConverters = new ArrayList<PropertyConverter<T>>();
            if (converters != null) {
                newConverters.addAll(converters);
            }
            newConverters.add(converter);
            Collections.sort(newConverters, PRIORITY_COMPARATOR);
            this.converters.put(targetType, Collections.unmodifiableList(newConverters));
            for (Class<?> ifaceType : targetType.getRawType().getInterfaces()) {
                converters = (List)List.class.cast(this.transitiveConverters.get(TypeLiteral.of(ifaceType)));
                newConverters = new ArrayList();
                if (converters != null) {
                    newConverters.addAll(converters);
                }
                newConverters.add(converter);
                Collections.sort(newConverters, PRIORITY_COMPARATOR);
                this.transitiveConverters.put(TypeLiteral.of(ifaceType), Collections.unmodifiableList(newConverters));
            }
            for (Class<T> superClass = targetType.getRawType().getSuperclass(); superClass != null && !superClass.equals(Object.class); superClass = superClass.getSuperclass()) {
                converters = (List)List.class.cast(this.transitiveConverters.get(TypeLiteral.of(superClass)));
                newConverters = new ArrayList();
                if (converters != null) {
                    newConverters.addAll(converters);
                }
                newConverters.add(converter);
                Collections.sort(newConverters, PRIORITY_COMPARATOR);
                this.transitiveConverters.put(TypeLiteral.of(superClass), Collections.unmodifiableList(newConverters));
                for (Class<?> ifaceType : superClass.getInterfaces()) {
                    converters = (List)List.class.cast(this.transitiveConverters.get(TypeLiteral.of(ifaceType)));
                    newConverters = new ArrayList();
                    if (converters != null) {
                        newConverters.addAll(converters);
                    }
                    newConverters.add(converter);
                    Collections.sort(newConverters, PRIORITY_COMPARATOR);
                    this.transitiveConverters.put(TypeLiteral.of(ifaceType), Collections.unmodifiableList(newConverters));
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean isTargetTypeSupported(TypeLiteral<?> targetType) {
        return this.converters.containsKey(targetType) || this.transitiveConverters.containsKey(targetType) || this.createDefaultPropertyConverter(targetType) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TypeLiteral<?>, List<PropertyConverter<?>>> getPropertyConverters() {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            HashMap hashMap = new HashMap(this.converters);
            return hashMap;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<PropertyConverter<T>> getPropertyConverters(TypeLiteral<T> targetType) {
        PropertyConverter<T> defaultConverter;
        Lock readLock = this.lock.readLock();
        ArrayList<PropertyConverter<T>> converterList = new ArrayList<PropertyConverter<T>>();
        try {
            readLock.lock();
            this.addConvertersToList((Collection)List.class.cast(this.converters.get(targetType)), converterList);
        }
        finally {
            readLock.unlock();
        }
        try {
            readLock.lock();
            this.addConvertersToList((Collection)List.class.cast(this.transitiveConverters.get(targetType)), converterList);
        }
        finally {
            readLock.unlock();
        }
        TypeLiteral<T> boxedType = this.mapBoxedType(targetType);
        if (boxedType != null) {
            try {
                readLock.lock();
                this.addConvertersToList((Collection)List.class.cast(this.converters.get(boxedType)), converterList);
            }
            finally {
                readLock.unlock();
            }
        }
        if (converterList.isEmpty() && (defaultConverter = this.createDefaultPropertyConverter(targetType)) != null) {
            this.register(targetType, defaultConverter);
            try {
                readLock.lock();
                this.addConvertersToList((Collection)List.class.cast(this.converters.get(targetType)), converterList);
            }
            finally {
                readLock.unlock();
            }
        }
        if (targetType.getType() != null) {
            try {
                readLock.lock();
                this.addConvertersToList((Collection)List.class.cast(this.converters.get(TypeLiteral.of(targetType.getRawType()))), converterList);
            }
            finally {
                readLock.unlock();
            }
        }
        return converterList;
    }

    private <T> void addConvertersToList(Collection<PropertyConverter<T>> converters, List<PropertyConverter<T>> converterList) {
        if (converters != null) {
            for (PropertyConverter<T> conv : converters) {
                if (converterList.contains(conv)) continue;
                converterList.add(conv);
            }
        }
    }

    private <T> TypeLiteral<T> mapBoxedType(TypeLiteral<T> targetType) {
        Type parameterType = targetType.getType();
        if (parameterType == Integer.TYPE) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Integer.class));
        }
        if (parameterType == Short.TYPE) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Short.class));
        }
        if (parameterType == Byte.TYPE) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Byte.class));
        }
        if (parameterType == Long.TYPE) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Long.class));
        }
        if (parameterType == Boolean.TYPE) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Boolean.class));
        }
        if (parameterType == Character.TYPE) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Character.class));
        }
        if (parameterType == Float.TYPE) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Float.class));
        }
        if (parameterType == Double.TYPE) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Double.class));
        }
        if (parameterType == int[].class) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Integer[].class));
        }
        if (parameterType == short[].class) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Short[].class));
        }
        if (parameterType == byte[].class) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Byte[].class));
        }
        if (parameterType == long[].class) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Long[].class));
        }
        if (parameterType == Boolean.TYPE) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Boolean.class));
        }
        if (parameterType == char[].class) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Character[].class));
        }
        if (parameterType == float[].class) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Float[].class));
        }
        if (parameterType == double[].class) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Double[].class));
        }
        return null;
    }

    protected <T> PropertyConverter<T> createDefaultPropertyConverter(final TypeLiteral<T> targetType) {
        if (Enum.class.isAssignableFrom(targetType.getRawType())) {
            return new EnumConverter<T>(targetType.getRawType());
        }
        PropertyConverter<T> converter = null;
        Method factoryMethod = this.getFactoryMethod(targetType.getRawType(), "of", "valueOf", "instanceOf", "getInstance", "from", "fromString", "parse");
        if (factoryMethod != null) {
            converter = new DefaultPropertyConverter<T>(factoryMethod, targetType.getRawType());
        }
        if (converter == null) {
            Constructor<T> constr;
            try {
                constr = targetType.getRawType().getDeclaredConstructor(String.class);
            }
            catch (NoSuchMethodException e) {
                LOG.log(Level.FINEST, "No matching constrctor for " + targetType, e);
                return null;
            }
            converter = new PropertyConverter<T>(){

                @Override
                public T convert(String value, ConversionContext context) {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                @Override
                                public Object run() {
                                    constr.setAccessible(true);
                                    return null;
                                }
                            });
                            return null;
                        }
                    });
                    try {
                        return constr.newInstance(value);
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, "Error creating new PropertyConverter instance " + targetType, e);
                        return null;
                    }
                }
            };
        }
        return converter;
    }

    private Method getFactoryMethod(Class<?> type, String ... methodNames) {
        for (String name : methodNames) {
            try {
                Method m = type.getDeclaredMethod(name, String.class);
                return m;
            }
            catch (NoSuchMethodException | RuntimeException e) {
                LOG.finest("No such factory method found on type: " + type.getName() + ", methodName: " + name);
            }
        }
        return null;
    }

    private static class DefaultPropertyConverter<T>
    implements PropertyConverter<T> {
        private final Method factoryMethod;
        private final Class<T> targetType;

        DefaultPropertyConverter(Method factoryMethod, Class<T> targetType) {
            this.factoryMethod = Objects.requireNonNull(factoryMethod);
            this.targetType = Objects.requireNonNull(targetType);
        }

        @Override
        public T convert(String value, ConversionContext context) {
            context.addSupportedFormats(this.getClass(), "<String -> " + this.factoryMethod.toGenericString());
            if (!Modifier.isStatic(this.factoryMethod.getModifiers())) {
                throw new ConfigException(this.factoryMethod.toGenericString() + " is not a static method. Only static " + "methods can be used as factory methods.");
            }
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        DefaultPropertyConverter.this.factoryMethod.setAccessible(true);
                        return null;
                    }
                });
                Object invoke = this.factoryMethod.invoke(null, value);
                return this.targetType.cast(invoke);
            }
            catch (Exception e) {
                throw new ConfigException("Failed to decode '" + value + "'", e);
            }
        }
    }
}

