/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.JsonNumber;
import javax.json.JsonValue;

final class JsonNumberImpl
implements JsonNumber {
    private final BigDecimal value;
    private Integer hashCode = null;

    JsonNumberImpl(BigDecimal decimal) {
        if (decimal == null) {
            throw new NullPointerException("decimal must not be null");
        }
        this.value = decimal;
    }

    @Override
    public boolean isIntegral() {
        return this.value.scale() == 0;
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public int intValueExact() {
        return this.value.intValueExact();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public long longValueExact() {
        return this.value.longValueExact();
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.value.toBigInteger();
    }

    @Override
    public BigInteger bigIntegerValueExact() {
        return this.value.toBigIntegerExact();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return this.value;
    }

    @Override
    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.NUMBER;
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public int hashCode() {
        Integer h = this.hashCode;
        if (h == null) {
            this.hashCode = h = Integer.valueOf(this.value.hashCode());
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return JsonNumber.class.isInstance(obj) && ((JsonNumber)JsonNumber.class.cast(obj)).bigDecimalValue().equals(this.value);
    }
}

