/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.impl.type;

import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumStringArgumentType<T extends Enum<T>>
implements ArgumentType<T> {
    private Class<T> type_;

    public EnumStringArgumentType(Class<T> type) {
        this.type_ = type;
    }

    public static <T extends Enum<T>> EnumStringArgumentType<T> forEnum(Class<T> type) {
        return new EnumStringArgumentType<T>(type);
    }

    @Override
    public T convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
        for (Enum t : (Enum[])this.type_.getEnumConstants()) {
            if (!t.toString().equals(value)) continue;
            return (T)t;
        }
        String choices = TextHelper.concat(this.type_.getEnumConstants(), 0, ",", "{", "}");
        throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, "could not convert '%s' (choose from %s)", value, choices), parser, arg);
    }
}

