/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.validation;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import io.dropwizard.validation.ValidationMethod;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;

public class ConstraintViolations {
    private static final Joiner DOT_JOINER = Joiner.on('.');

    private ConstraintViolations() {
    }

    public static <T> String format(ConstraintViolation<T> v) {
        if (v.getConstraintDescriptor().getAnnotation() instanceof ValidationMethod) {
            return ConstraintViolations.validationMethodFormatted(v);
        }
        return String.format("%s %s", v.getPropertyPath(), v.getMessage());
    }

    public static <T> String validationMethodFormatted(ConstraintViolation<T> v) {
        ImmutableList<Path.Node> nodes = ImmutableList.copyOf(v.getPropertyPath());
        String usefulNodes = DOT_JOINER.join(nodes.subList(0, nodes.size() - 1));
        String msg = usefulNodes + (v.getMessage().startsWith(".") ? "" : " ") + v.getMessage();
        return msg.trim();
    }

    public static <T> ImmutableList<String> format(Set<ConstraintViolation<T>> violations) {
        HashSet<String> errors = Sets.newHashSet();
        for (ConstraintViolation<T> v : violations) {
            errors.add(ConstraintViolations.format(v));
        }
        return ImmutableList.copyOf(Ordering.natural().sortedCopy(errors));
    }

    public static ImmutableList<String> formatUntyped(Set<ConstraintViolation<?>> violations) {
        HashSet<String> errors = Sets.newHashSet();
        for (ConstraintViolation<?> v : violations) {
            errors.add(ConstraintViolations.format(v));
        }
        return ImmutableList.copyOf(Ordering.natural().sortedCopy(errors));
    }

    public static <T> ImmutableSet<ConstraintViolation<?>> copyOf(Set<ConstraintViolation<T>> violations) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ConstraintViolation<T> violation : violations) {
            builder.add(violation);
        }
        return builder.build();
    }

    public static <T extends ConstraintViolation<?>> int determineStatus(Set<T> violations) {
        if (violations.size() > 0) {
            ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
            for (Path.Node node : violation.getPropertyPath()) {
                switch (node.getKind()) {
                    case RETURN_VALUE: {
                        return 500;
                    }
                    case PARAMETER: {
                        return 400;
                    }
                }
            }
        }
        return 422;
    }
}

