/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.servlets;

import io.dropwizard.servlets.Servlets;
import io.dropwizard.util.Duration;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlowRequestFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlowRequestFilter.class);
    private final long threshold;

    public SlowRequestFilter() {
        this(Duration.seconds(1L));
    }

    public SlowRequestFilter(Duration threshold) {
        this.threshold = threshold.toNanoseconds();
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        long startTime = System.nanoTime();
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable throwable) {
            long elapsedNS = System.nanoTime() - startTime;
            long elapsedMS = TimeUnit.NANOSECONDS.toMillis(elapsedNS);
            if (elapsedNS >= this.threshold) {
                LOGGER.warn("Slow request: {} {} ({}ms)", req.getMethod(), Servlets.getFullUrl(req), elapsedMS);
            }
            throw throwable;
        }
        long elapsedNS = System.nanoTime() - startTime;
        long elapsedMS = TimeUnit.NANOSECONDS.toMillis(elapsedNS);
        if (elapsedNS >= this.threshold) {
            LOGGER.warn("Slow request: {} {} ({}ms)", req.getMethod(), Servlets.getFullUrl(req), elapsedMS);
        }
    }
}

