/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.server;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.jetty9.InstrumentedHandler;
import com.codahale.metrics.jetty9.InstrumentedQueuedThreadPool;
import com.codahale.metrics.servlets.AdminServlet;
import com.codahale.metrics.servlets.HealthCheckServlet;
import com.codahale.metrics.servlets.MetricsServlet;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Resources;
import io.dropwizard.jersey.errors.EarlyEofExceptionMapper;
import io.dropwizard.jersey.errors.LoggingExceptionMapper;
import io.dropwizard.jersey.filter.AllowedMethodsFilter;
import io.dropwizard.jersey.jackson.JacksonMessageBodyProvider;
import io.dropwizard.jersey.jackson.JsonProcessingExceptionMapper;
import io.dropwizard.jersey.setup.JerseyEnvironment;
import io.dropwizard.jersey.validation.ConstraintViolationExceptionMapper;
import io.dropwizard.jetty.GzipFilterFactory;
import io.dropwizard.jetty.MutableServletContextHandler;
import io.dropwizard.jetty.NonblockingServletHolder;
import io.dropwizard.jetty.RequestLogFactory;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.server.ServerFactory;
import io.dropwizard.servlets.ThreadNameFilter;
import io.dropwizard.util.Duration;
import io.dropwizard.validation.MinDuration;
import io.dropwizard.validation.ValidationMethod;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.validation.Valid;
import javax.validation.Validator;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.setuid.RLimit;
import org.eclipse.jetty.setuid.SetUIDListener;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerFactory
implements ServerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerFactory.class);
    private static final Pattern WINDOWS_NEWLINE = Pattern.compile("\\r\\n?");
    @Valid
    @NotNull
    private RequestLogFactory requestLog = new RequestLogFactory();
    @Valid
    @NotNull
    private GzipFilterFactory gzip = new GzipFilterFactory();
    @Min(value=2L)
    private int maxThreads = 1024;
    @Min(value=1L)
    private int minThreads = 8;
    private int maxQueuedRequests = 1024;
    @MinDuration(value=1L)
    private Duration idleThreadTimeout = Duration.minutes(1L);
    @Min(value=1L)
    private Integer nofileSoftLimit;
    @Min(value=1L)
    private Integer nofileHardLimit;
    private Integer gid;
    private Integer uid;
    private String user;
    private String group;
    private String umask;
    private Boolean startsAsRoot;
    private Boolean registerDefaultExceptionMappers = Boolean.TRUE;
    private Duration shutdownGracePeriod = Duration.seconds(30L);
    @NotNull
    private Set<String> allowedMethods = AllowedMethodsFilter.DEFAULT_ALLOWED_METHODS;
    @NotEmpty
    private String jerseyRootPath = "/";

    @JsonIgnore
    @ValidationMethod(message="must have a smaller minThreads than maxThreads")
    public boolean isThreadPoolSizedCorrectly() {
        return this.minThreads <= this.maxThreads;
    }

    @JsonProperty(value="requestLog")
    public RequestLogFactory getRequestLogFactory() {
        return this.requestLog;
    }

    @JsonProperty(value="requestLog")
    public void setRequestLogFactory(RequestLogFactory requestLog) {
        this.requestLog = requestLog;
    }

    @JsonProperty(value="gzip")
    public GzipFilterFactory getGzipFilterFactory() {
        return this.gzip;
    }

    @JsonProperty(value="gzip")
    public void setGzipFilterFactory(GzipFilterFactory gzip) {
        this.gzip = gzip;
    }

    @JsonProperty
    public int getMaxThreads() {
        return this.maxThreads;
    }

    @JsonProperty
    public void setMaxThreads(int count) {
        this.maxThreads = count;
    }

    @JsonProperty
    public int getMinThreads() {
        return this.minThreads;
    }

    @JsonProperty
    public void setMinThreads(int count) {
        this.minThreads = count;
    }

    @JsonProperty
    public int getMaxQueuedRequests() {
        return this.maxQueuedRequests;
    }

    @JsonProperty
    public void setMaxQueuedRequests(int maxQueuedRequests) {
        this.maxQueuedRequests = maxQueuedRequests;
    }

    @JsonProperty
    public Duration getIdleThreadTimeout() {
        return this.idleThreadTimeout;
    }

    @JsonProperty
    public void setIdleThreadTimeout(Duration idleThreadTimeout) {
        this.idleThreadTimeout = idleThreadTimeout;
    }

    @JsonProperty
    public Integer getNofileSoftLimit() {
        return this.nofileSoftLimit;
    }

    @JsonProperty
    public void setNofileSoftLimit(Integer nofileSoftLimit) {
        this.nofileSoftLimit = nofileSoftLimit;
    }

    @JsonProperty
    public Integer getNofileHardLimit() {
        return this.nofileHardLimit;
    }

    @JsonProperty
    public void setNofileHardLimit(Integer nofileHardLimit) {
        this.nofileHardLimit = nofileHardLimit;
    }

    @JsonProperty
    public Integer getGid() {
        return this.gid;
    }

    @JsonProperty
    public void setGid(Integer gid) {
        this.gid = gid;
    }

    @JsonProperty
    public Integer getUid() {
        return this.uid;
    }

    @JsonProperty
    public void setUid(Integer uid) {
        this.uid = uid;
    }

    @JsonProperty
    public String getUser() {
        return this.user;
    }

    @JsonProperty
    public void setUser(String user) {
        this.user = user;
    }

    @JsonProperty
    public String getGroup() {
        return this.group;
    }

    @JsonProperty
    public void setGroup(String group) {
        this.group = group;
    }

    @JsonProperty
    public String getUmask() {
        return this.umask;
    }

    @JsonProperty
    public void setUmask(String umask) {
        this.umask = umask;
    }

    @JsonProperty
    public Boolean getStartsAsRoot() {
        return this.startsAsRoot;
    }

    @JsonProperty
    public void setStartsAsRoot(Boolean startsAsRoot) {
        this.startsAsRoot = startsAsRoot;
    }

    public Boolean getRegisterDefaultExceptionMappers() {
        return this.registerDefaultExceptionMappers;
    }

    public void setRegisterDefaultExceptionMappers(Boolean registerDefaultExceptionMappers) {
        this.registerDefaultExceptionMappers = registerDefaultExceptionMappers;
    }

    @JsonProperty
    public Duration getShutdownGracePeriod() {
        return this.shutdownGracePeriod;
    }

    @JsonProperty
    public void setShutdownGracePeriod(Duration shutdownGracePeriod) {
        this.shutdownGracePeriod = shutdownGracePeriod;
    }

    @JsonProperty
    public Set<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    @JsonProperty
    public void setAllowedMethods(Set<String> allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    @JsonProperty(value="rootPath")
    public String getJerseyRootPath() {
        return this.jerseyRootPath;
    }

    @JsonProperty(value="rootPath")
    public void setJerseyRootPath(String jerseyRootPath) {
        this.jerseyRootPath = jerseyRootPath;
    }

    protected Handler createAdminServlet(Server server, MutableServletContextHandler handler, MetricRegistry metrics, HealthCheckRegistry healthChecks) {
        this.configureSessionsAndSecurity(handler, server);
        handler.setServer(server);
        handler.getServletContext().setAttribute(MetricsServlet.METRICS_REGISTRY, metrics);
        handler.getServletContext().setAttribute(HealthCheckServlet.HEALTH_CHECK_REGISTRY, healthChecks);
        handler.addServlet(new NonblockingServletHolder(new AdminServlet()), "/*");
        handler.addFilter(AllowedMethodsFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setInitParameter("allowedMethods", Joiner.on(',').join(this.allowedMethods));
        return handler;
    }

    private void configureSessionsAndSecurity(MutableServletContextHandler handler, Server server) {
        handler.setServer(server);
        if (handler.isSecurityEnabled()) {
            handler.getSecurityHandler().setServer(server);
        }
        if (handler.isSessionsEnabled()) {
            handler.getSessionHandler().setServer(server);
        }
    }

    protected Handler createAppServlet(Server server, JerseyEnvironment jersey, ObjectMapper objectMapper, Validator validator, MutableServletContextHandler handler, @Nullable Servlet jerseyContainer, MetricRegistry metricRegistry) {
        this.configureSessionsAndSecurity(handler, server);
        handler.addFilter(AllowedMethodsFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setInitParameter("allowedMethods", Joiner.on(',').join(this.allowedMethods));
        handler.addFilter(ThreadNameFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        if (this.gzip.isEnabled()) {
            FilterHolder holder = new FilterHolder(this.gzip.build());
            handler.addFilter(holder, "/*", EnumSet.allOf(DispatcherType.class));
        }
        if (jerseyContainer != null) {
            String urlPattern = this.jerseyRootPath;
            if (!urlPattern.endsWith("*") && !urlPattern.endsWith("/")) {
                urlPattern = urlPattern + "/";
            }
            if (!urlPattern.endsWith("*")) {
                urlPattern = urlPattern + "*";
            }
            jersey.setUrlPattern(urlPattern);
            jersey.register(new JacksonMessageBodyProvider(objectMapper, validator));
            if (this.registerDefaultExceptionMappers == null || this.registerDefaultExceptionMappers.booleanValue()) {
                jersey.register(new LoggingExceptionMapper<Throwable>(){});
                jersey.register(new ConstraintViolationExceptionMapper());
                jersey.register(new JsonProcessingExceptionMapper());
                jersey.register(new EarlyEofExceptionMapper());
            }
            handler.addServlet(new NonblockingServletHolder(jerseyContainer), jersey.getUrlPattern());
        }
        InstrumentedHandler instrumented = new InstrumentedHandler(metricRegistry);
        instrumented.setServer(server);
        instrumented.setHandler(handler);
        return instrumented;
    }

    protected ThreadPool createThreadPool(MetricRegistry metricRegistry) {
        BlockingArrayQueue<Runnable> queue = new BlockingArrayQueue<Runnable>(this.minThreads, this.maxThreads, this.maxQueuedRequests);
        InstrumentedQueuedThreadPool threadPool = new InstrumentedQueuedThreadPool(metricRegistry, this.maxThreads, this.minThreads, (int)this.idleThreadTimeout.toMilliseconds(), queue);
        threadPool.setName("dw");
        return threadPool;
    }

    protected Server buildServer(LifecycleEnvironment lifecycle, ThreadPool threadPool) {
        Server server = new Server(threadPool);
        server.addLifeCycleListener(this.buildSetUIDListener());
        lifecycle.attach(server);
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setServer(server);
        errorHandler.setShowStacks(false);
        server.addBean(errorHandler);
        server.setStopAtShutdown(true);
        server.setStopTimeout(this.shutdownGracePeriod.toMilliseconds());
        return server;
    }

    protected SetUIDListener buildSetUIDListener() {
        SetUIDListener listener = new SetUIDListener();
        if (this.startsAsRoot != null) {
            listener.setStartServerAsPrivileged(this.startsAsRoot);
        }
        if (this.gid != null) {
            listener.setGid(this.gid);
        }
        if (this.uid != null) {
            listener.setUid(this.uid);
        }
        if (this.user != null) {
            listener.setUsername(this.user);
        }
        if (this.group != null) {
            listener.setGroupname(this.group);
        }
        if (this.nofileHardLimit != null || this.nofileSoftLimit != null) {
            RLimit rlimit = new RLimit();
            if (this.nofileHardLimit != null) {
                rlimit.setHard(this.nofileHardLimit);
            }
            if (this.nofileSoftLimit != null) {
                rlimit.setSoft(this.nofileSoftLimit);
            }
            listener.setRLimitNoFiles(rlimit);
        }
        if (this.umask != null) {
            listener.setUmaskOctal(this.umask);
        }
        return listener;
    }

    protected Handler addRequestLog(Server server, Handler handler, String name) {
        if (this.requestLog.isEnabled()) {
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            requestLogHandler.setRequestLog(this.requestLog.build(name));
            server.addBean((Object)requestLogHandler.getRequestLog(), true);
            requestLogHandler.setHandler(handler);
            return requestLogHandler;
        }
        return handler;
    }

    protected Handler addStatsHandler(Handler handler) {
        StatisticsHandler statisticsHandler = new StatisticsHandler();
        statisticsHandler.setHandler(handler);
        return statisticsHandler;
    }

    protected void printBanner(String name) {
        try {
            String banner = WINDOWS_NEWLINE.matcher(Resources.toString(Resources.getResource("banner.txt"), Charsets.UTF_8)).replaceAll("\n").replace("\n", String.format("%n", new Object[0]));
            LOGGER.info(String.format("Starting {}%n{}", new Object[0]), (Object)name, (Object)banner);
        }
        catch (IOException | IllegalArgumentException ignored) {
            LOGGER.info("Starting {}", (Object)name);
        }
    }
}

