/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics;

import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.metrics.BaseFormattedReporterFactory;
import java.io.File;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="csv")
public class CsvReporterFactory
extends BaseFormattedReporterFactory {
    @NotNull
    private File file;

    @JsonProperty
    public File getFile() {
        return this.file;
    }

    @JsonProperty
    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public ScheduledReporter build(MetricRegistry registry) {
        boolean creation = this.file.mkdirs();
        if (!creation && !this.file.exists()) {
            String msg = "Failed to create" + this.file.getAbsolutePath();
            throw new RuntimeException(msg);
        }
        return CsvReporter.forRegistry(registry).convertDurationsTo(this.getDurationUnit()).convertRatesTo(this.getRateUnit()).filter(this.getFilter()).formatFor(this.getLocale()).build(this.getFile());
    }
}

