/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicyBase;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.AbstractAppenderFactory;
import io.dropwizard.util.Size;
import io.dropwizard.validation.ValidationMethod;
import java.util.TimeZone;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="file")
public class FileAppenderFactory
extends AbstractAppenderFactory {
    @NotNull
    private String currentLogFilename;
    private boolean archive = true;
    private String archivedLogFilenamePattern;
    @Min(value=1L)
    private int archivedFileCount = 5;
    private Size maxFileSize;
    @NotNull
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");

    @JsonProperty
    public String getCurrentLogFilename() {
        return this.currentLogFilename;
    }

    @JsonProperty
    public void setCurrentLogFilename(String currentLogFilename) {
        this.currentLogFilename = currentLogFilename;
    }

    @JsonProperty
    public boolean isArchive() {
        return this.archive;
    }

    @JsonProperty
    public void setArchive(boolean archive) {
        this.archive = archive;
    }

    @JsonProperty
    public String getArchivedLogFilenamePattern() {
        return this.archivedLogFilenamePattern;
    }

    @JsonProperty
    public void setArchivedLogFilenamePattern(String archivedLogFilenamePattern) {
        this.archivedLogFilenamePattern = archivedLogFilenamePattern;
    }

    @JsonProperty
    public int getArchivedFileCount() {
        return this.archivedFileCount;
    }

    @JsonProperty
    public void setArchivedFileCount(int archivedFileCount) {
        this.archivedFileCount = archivedFileCount;
    }

    @JsonProperty
    public Size getMaxFileSize() {
        return this.maxFileSize;
    }

    @JsonProperty
    public void setMaxFileSize(Size maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    @JsonProperty
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @JsonProperty
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @JsonIgnore
    @ValidationMethod(message="must have archivedLogFilenamePattern if archive is true")
    public boolean isValidArchiveConfiguration() {
        return !this.archive || this.archivedLogFilenamePattern != null;
    }

    @JsonIgnore
    @ValidationMethod(message="when specifying maxFileSize, archivedLogFilenamePattern must contain %i")
    public boolean isValidForMaxFileSizeSetting() {
        return !this.archive || this.maxFileSize == null || this.archivedLogFilenamePattern != null && this.archivedLogFilenamePattern.contains("%i");
    }

    @JsonIgnore
    @ValidationMethod(message="when archivedLogFilenamePattern contains %i, maxFileSize must be specified")
    public boolean isMaxFileSizeSettingSpecified() {
        return !this.archive || this.archivedLogFilenamePattern == null || !this.archivedLogFilenamePattern.contains("%i") || this.maxFileSize != null;
    }

    @Override
    public Appender<ILoggingEvent> build(LoggerContext context, String applicationName, Layout<ILoggingEvent> layout) {
        FileAppender<ILoggingEvent> appender = this.buildAppender(context);
        appender.setName("file-appender");
        appender.setAppend(true);
        appender.setContext(context);
        LayoutWrappingEncoder<ILoggingEvent> layoutEncoder = new LayoutWrappingEncoder<ILoggingEvent>();
        layoutEncoder.setLayout(layout == null ? this.buildLayout(context, this.timeZone) : layout);
        appender.setEncoder(layoutEncoder);
        appender.setPrudent(false);
        this.addThresholdFilter(appender, this.threshold);
        appender.stop();
        appender.start();
        return this.wrapAsync(appender);
    }

    protected FileAppender<ILoggingEvent> buildAppender(LoggerContext context) {
        if (this.archive) {
            TimeBasedFileNamingAndTriggeringPolicyBase triggeringPolicy;
            RollingFileAppender<ILoggingEvent> appender = new RollingFileAppender<ILoggingEvent>();
            appender.setFile(this.currentLogFilename);
            if (this.maxFileSize != null && !this.archivedLogFilenamePattern.contains("%d")) {
                FixedWindowRollingPolicy rollingPolicy = new FixedWindowRollingPolicy();
                SizeBasedTriggeringPolicy triggeringPolicy2 = new SizeBasedTriggeringPolicy();
                triggeringPolicy2.setMaxFileSize(String.valueOf(this.maxFileSize.toBytes()));
                triggeringPolicy2.setContext(context);
                rollingPolicy.setContext(context);
                rollingPolicy.setMaxIndex(this.getArchivedFileCount());
                rollingPolicy.setFileNamePattern(this.getArchivedLogFilenamePattern());
                appender.setRollingPolicy(rollingPolicy);
                appender.setTriggeringPolicy(triggeringPolicy2);
                rollingPolicy.setParent(appender);
                rollingPolicy.start();
                return appender;
            }
            if (this.maxFileSize == null) {
                triggeringPolicy = new DefaultTimeBasedFileNamingAndTriggeringPolicy();
            } else {
                SizeAndTimeBasedFNATP maxFileSizeTriggeringPolicy = new SizeAndTimeBasedFNATP();
                maxFileSizeTriggeringPolicy.setMaxFileSize(String.valueOf(this.maxFileSize.toBytes()));
                triggeringPolicy = maxFileSizeTriggeringPolicy;
            }
            triggeringPolicy.setContext(context);
            TimeBasedRollingPolicy rollingPolicy = new TimeBasedRollingPolicy();
            rollingPolicy.setContext(context);
            rollingPolicy.setFileNamePattern(this.archivedLogFilenamePattern);
            rollingPolicy.setTimeBasedFileNamingAndTriggeringPolicy(triggeringPolicy);
            triggeringPolicy.setTimeBasedRollingPolicy(rollingPolicy);
            rollingPolicy.setMaxHistory(this.archivedFileCount);
            appender.setRollingPolicy(rollingPolicy);
            appender.setTriggeringPolicy(triggeringPolicy);
            rollingPolicy.setParent(appender);
            rollingPolicy.start();
            return appender;
        }
        FileAppender<ILoggingEvent> appender = new FileAppender<ILoggingEvent>();
        appender.setFile(this.currentLogFilename);
        return appender;
    }
}

