/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import io.dropwizard.logging.DropwizardLayout;
import io.dropwizard.logging.LoggingUtil;
import java.util.TimeZone;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;

public class BootstrapLogging {
    @GuardedBy(value="bootsrappingLock")
    private static boolean bootstrapped = false;
    private static final Lock bootstrappingLock = new ReentrantLock();

    private BootstrapLogging() {
    }

    public static void bootstrap() {
        BootstrapLogging.bootstrap(Level.WARN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bootstrap(Level level) {
        LoggingUtil.hijackJDKLogging();
        bootstrappingLock.lock();
        try {
            if (bootstrapped) {
                return;
            }
            Logger root = LoggingUtil.getLoggerContext().getLogger("ROOT");
            root.detachAndStopAllAppenders();
            DropwizardLayout formatter = new DropwizardLayout(root.getLoggerContext(), TimeZone.getDefault());
            formatter.start();
            ThresholdFilter filter = new ThresholdFilter();
            filter.setLevel(level.toString());
            filter.start();
            ConsoleAppender<ILoggingEvent> appender = new ConsoleAppender<ILoggingEvent>();
            appender.addFilter(filter);
            appender.setContext(root.getLoggerContext());
            LayoutWrappingEncoder<ILoggingEvent> layoutEncoder = new LayoutWrappingEncoder<ILoggingEvent>();
            layoutEncoder.setLayout(formatter);
            appender.setEncoder(layoutEncoder);
            appender.start();
            root.addAppender((Appender<ILoggingEvent>)appender);
            bootstrapped = true;
        }
        finally {
            bootstrappingLock.unlock();
        }
    }
}

