/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.validation;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterables;
import io.dropwizard.validation.ConstraintViolations;
import io.dropwizard.validation.ValidationMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.metadata.ConstraintDescriptor;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ConstraintMessage {
    private static final Cache<Pair<Path, ? extends ConstraintDescriptor<?>>, String> MESSAGES_CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();

    private ConstraintMessage() {
    }

    public static String getMessage(ConstraintViolation<?> v) {
        Pair<Path, ConstraintDescriptor<?>> of = Pair.of(v.getPropertyPath(), v.getConstraintDescriptor());
        String message = MESSAGES_CACHE.getIfPresent(of);
        if (message == null) {
            message = ConstraintMessage.calculateMessage(v);
            MESSAGES_CACHE.put(of, message);
        }
        return message;
    }

    private static String calculateMessage(ConstraintViolation<?> v) {
        Optional<String> returnValueName = ConstraintMessage.getMethodReturnValueName(v);
        if (returnValueName.isPresent()) {
            String name = ConstraintMessage.isValidationMethod(v) ? StringUtils.substringBeforeLast(returnValueName.get(), ".") : returnValueName.get();
            return name + " " + v.getMessage();
        }
        if (ConstraintMessage.isValidationMethod(v)) {
            return ConstraintViolations.validationMethodFormatted(v);
        }
        String name = ConstraintMessage.getMemberName(v).or(v.getPropertyPath().toString());
        return name + " " + v.getMessage();
    }

    private static Optional<String> getMemberName(ConstraintViolation<?> violation) {
        int size = Iterables.size(violation.getPropertyPath());
        if (size < 2) {
            return Optional.absent();
        }
        Path.Node parent = Iterables.get(violation.getPropertyPath(), size - 2);
        Path.Node member = Iterables.getLast(violation.getPropertyPath());
        Class<?> resourceClass = violation.getLeafBean().getClass();
        switch (parent.getKind()) {
            case PARAMETER: {
                Field field = FieldUtils.getField(resourceClass, member.getName(), true);
                return ConstraintMessage.getMemberName(field.getDeclaredAnnotations());
            }
            case METHOD: {
                List<Class<?>> params = parent.as(Path.MethodNode.class).getParameterTypes();
                Class[] parcs = params.toArray(new Class[params.size()]);
                Method method = MethodUtils.getAccessibleMethod(resourceClass, parent.getName(), parcs);
                int paramIndex = member.as(Path.ParameterNode.class).getParameterIndex();
                return ConstraintMessage.getMemberName(method.getParameterAnnotations()[paramIndex]);
            }
        }
        return Optional.absent();
    }

    private static Optional<String> getMethodReturnValueName(ConstraintViolation<?> violation) {
        int returnValueNames = -1;
        StringBuilder result = new StringBuilder("server response");
        for (Path.Node node : violation.getPropertyPath()) {
            if (node.getKind().equals((Object)ElementKind.RETURN_VALUE)) {
                returnValueNames = 0;
                continue;
            }
            if (returnValueNames < 0) continue;
            result.append(returnValueNames++ == 0 ? " " : ".").append(node);
        }
        return returnValueNames >= 0 ? Optional.of(result.toString()) : Optional.absent();
    }

    private static Optional<String> getMemberName(Annotation[] memberAnnotations) {
        for (Annotation a : memberAnnotations) {
            if (a instanceof QueryParam) {
                return Optional.of("query param " + ((QueryParam)a).value());
            }
            if (a instanceof PathParam) {
                return Optional.of("path param " + ((PathParam)a).value());
            }
            if (a instanceof HeaderParam) {
                return Optional.of("header " + ((HeaderParam)a).value());
            }
            if (a instanceof CookieParam) {
                return Optional.of("cookie " + ((CookieParam)a).value());
            }
            if (a instanceof FormParam) {
                return Optional.of("form field " + ((FormParam)a).value());
            }
            if (a instanceof Context) {
                return Optional.of("context");
            }
            if (!(a instanceof MatrixParam)) continue;
            return Optional.of("matrix param " + ((MatrixParam)a).value());
        }
        return Optional.absent();
    }

    private static boolean isValidationMethod(ConstraintViolation<?> v) {
        return v.getConstraintDescriptor().getAnnotation() instanceof ValidationMethod;
    }
}

