/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.setup;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import io.dropwizard.jersey.DropwizardResourceConfig;
import io.dropwizard.jersey.setup.JerseyContainerHolder;
import javax.annotation.Nullable;
import javax.servlet.Servlet;
import org.glassfish.jersey.server.ResourceConfig;

public class JerseyEnvironment {
    private final JerseyContainerHolder holder;
    private final DropwizardResourceConfig config;

    public JerseyEnvironment(JerseyContainerHolder holder, DropwizardResourceConfig config) {
        this.holder = holder;
        this.config = config;
    }

    public void disable() {
        this.holder.setContainer(null);
    }

    public void replace(Function<ResourceConfig, Servlet> replace) {
        this.holder.setContainer(replace.apply(this.config));
    }

    public void register(Object component) {
        this.config.register(Preconditions.checkNotNull(component));
    }

    public void register(Class<?> componentClass) {
        this.config.register((Class)Preconditions.checkNotNull(componentClass));
    }

    public void packages(String ... packages) {
        this.config.packages(Preconditions.checkNotNull(packages));
    }

    public void enable(String featureName) {
        this.config.property(Preconditions.checkNotNull(featureName), Boolean.TRUE);
    }

    public void disable(String featureName) {
        this.config.property(Preconditions.checkNotNull(featureName), Boolean.FALSE);
    }

    public void property(String name, @Nullable Object value) {
        this.config.property(Preconditions.checkNotNull(name), value);
    }

    public <T> T getProperty(String name) {
        return (T)this.config.getProperties().get(name);
    }

    public String getUrlPattern() {
        return this.config.getUrlPattern();
    }

    public void setUrlPattern(String urlPattern) {
        this.config.setUrlPattern(urlPattern);
    }

    public DropwizardResourceConfig getResourceConfig() {
        return this.config;
    }
}

