/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.caching;

import io.dropwizard.jersey.caching.CacheControl;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.model.AnnotatedMethod;

@Provider
public class CacheControlledResponseFeature
implements DynamicFeature {
    @Override
    public void configure(ResourceInfo resourceInfo, FeatureContext configuration) {
        AnnotatedMethod am = new AnnotatedMethod(resourceInfo.getResourceMethod());
        CacheControl cc = am.getAnnotation(CacheControl.class);
        if (cc != null) {
            configuration.register(new CacheControlledResponseFilter(cc));
        }
    }

    private static class CacheControlledResponseFilter
    implements ContainerResponseFilter {
        private static final int ONE_YEAR_IN_SECONDS = (int)TimeUnit.DAYS.toSeconds(365L);
        private String cacheResponseHeader;

        public CacheControlledResponseFilter(CacheControl control) {
            javax.ws.rs.core.CacheControl cacheControl = new javax.ws.rs.core.CacheControl();
            cacheControl.setPrivate(control.isPrivate());
            cacheControl.setNoCache(control.noCache());
            cacheControl.setNoStore(control.noStore());
            cacheControl.setNoTransform(control.noTransform());
            cacheControl.setMustRevalidate(control.mustRevalidate());
            cacheControl.setProxyRevalidate(control.proxyRevalidate());
            cacheControl.setMaxAge((int)control.maxAgeUnit().toSeconds(control.maxAge()));
            cacheControl.setSMaxAge((int)control.sharedMaxAgeUnit().toSeconds(control.sharedMaxAge()));
            if (control.immutable()) {
                cacheControl.setMaxAge(ONE_YEAR_IN_SECONDS);
            }
            this.cacheResponseHeader = cacheControl.toString();
        }

        @Override
        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            if (!this.cacheResponseHeader.isEmpty()) {
                responseContext.getHeaders().add("Cache-Control", this.cacheResponseHeader);
            }
        }
    }
}

