/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jersey2.InstrumentedResourceMethodApplicationListener;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Sets;
import io.dropwizard.jersey.caching.CacheControlledResponseFeature;
import io.dropwizard.jersey.guava.OptionalMessageBodyWriter;
import io.dropwizard.jersey.guava.OptionalParamFeature;
import io.dropwizard.jersey.params.NonEmptyStringParamFeature;
import io.dropwizard.jersey.sessions.SessionFactoryProvider;
import io.dropwizard.jersey.validation.HibernateValidationFeature;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import org.glassfish.jersey.server.validation.ValidationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardResourceConfig
extends ResourceConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropwizardResourceConfig.class);
    private static final String NEWLINE = String.format("%n", new Object[0]);
    private static final TypeResolver TYPE_RESOLVER = new TypeResolver();
    private String urlPattern = "/*";

    public DropwizardResourceConfig(MetricRegistry metricRegistry) {
        this(false, metricRegistry);
    }

    public DropwizardResourceConfig() {
        this(true, null);
    }

    public DropwizardResourceConfig(boolean testOnly, MetricRegistry metricRegistry) {
        if (metricRegistry == null) {
            metricRegistry = new MetricRegistry();
        }
        this.property("jersey.config.server.wadl.disableWadl", Boolean.TRUE);
        if (!testOnly) {
            this.register(new ComponentLoggingListener(this));
        }
        this.register(new InstrumentedResourceMethodApplicationListener(metricRegistry));
        this.register((Class)CacheControlledResponseFeature.class);
        this.register((Class)OptionalMessageBodyWriter.class);
        this.register((Class)OptionalParamFeature.class);
        this.register((Class)NonEmptyStringParamFeature.class);
        this.register(new SessionFactoryProvider.Binder());
        this.register((Class)HibernateValidationFeature.class);
        this.register((Class)ValidationFeature.class);
    }

    public static DropwizardResourceConfig forTesting(MetricRegistry metricRegistry) {
        return new DropwizardResourceConfig(true, metricRegistry);
    }

    public void logComponents() {
        LOGGER.debug("resources = {}", (Object)this.canonicalNamesByAnnotation(Path.class));
        LOGGER.debug("providers = {}", (Object)this.canonicalNamesByAnnotation(Provider.class));
        LOGGER.info(this.getEndpointsInfo());
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    @VisibleForTesting
    Set<Class<?>> allClasses() {
        HashSet<Class<?>> allClasses = Sets.newHashSet(this.getClasses());
        for (Object singleton : this.getSingletons()) {
            allClasses.add(singleton.getClass());
        }
        return allClasses;
    }

    private Set<String> canonicalNamesByAnnotation(Class<? extends Annotation> annotation) {
        HashSet<String> result = Sets.newHashSet();
        for (Class<?> clazz : this.getClasses()) {
            if (!clazz.isAnnotationPresent(annotation)) continue;
            result.add(clazz.getCanonicalName());
        }
        return result;
    }

    public String getEndpointsInfo() {
        StringBuilder msg = new StringBuilder(1024);
        TreeSet<EndpointLogLine> endpointLogLines = Sets.newTreeSet(new EndpointComparator());
        msg.append("The following paths were found for the configured resources:");
        msg.append(NEWLINE).append(NEWLINE);
        HashSet<Class<?>> allResources = Sets.newHashSet();
        for (Class<?> clazz : this.allClasses()) {
            if (clazz.isInterface() || Resource.from(clazz) == null) continue;
            allResources.add(clazz);
        }
        for (Class<Object> clazz : allResources) {
            new EndpointLogger(this.urlPattern, clazz).populate(endpointLogLines);
        }
        if (!endpointLogLines.isEmpty()) {
            for (EndpointLogLine endpointLogLine : endpointLogLines) {
                msg.append(endpointLogLine).append(NEWLINE);
            }
        } else {
            msg.append("    NONE").append(NEWLINE);
        }
        return msg.toString();
    }

    private static class ComponentLoggingListener
    implements ApplicationEventListener {
        private final DropwizardResourceConfig config;

        public ComponentLoggingListener(DropwizardResourceConfig config) {
            this.config = config;
        }

        @Override
        public void onEvent(ApplicationEvent event) {
            if (event.getType() == ApplicationEvent.Type.INITIALIZATION_APP_FINISHED) {
                this.config.logComponents();
            }
        }

        @Override
        public RequestEventListener onRequest(RequestEvent requestEvent) {
            return null;
        }
    }

    private static class EndpointComparator
    implements Comparator<EndpointLogLine>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private EndpointComparator() {
        }

        @Override
        public int compare(EndpointLogLine endpointA, EndpointLogLine endpointB) {
            return ComparisonChain.start().compare((Comparable<?>)((Object)endpointA.basePath), (Comparable<?>)((Object)endpointB.basePath)).compare((Comparable<?>)((Object)endpointA.httpMethod), (Comparable<?>)((Object)endpointB.httpMethod)).result();
        }
    }

    private static class EndpointLogLine {
        private final String httpMethod;
        private final String basePath;
        private final Class<?> klass;

        public EndpointLogLine(String httpMethod, String basePath, Class<?> klass) {
            this.basePath = basePath;
            this.klass = klass;
            this.httpMethod = httpMethod;
        }

        public String toString() {
            return String.format("    %-7s %s (%s)", this.httpMethod, this.basePath, this.klass.getCanonicalName());
        }
    }

    private static class EndpointLogger {
        private final String rootPath;
        private final Class<?> klass;

        public EndpointLogger(String urlPattern, Class<?> klass) {
            this.rootPath = urlPattern.endsWith("/*") ? urlPattern.substring(0, urlPattern.length() - 1) : urlPattern;
            this.klass = klass;
        }

        public void populate(Set<EndpointLogLine> endpointLogLines) {
            this.populate(this.rootPath, this.klass, false, endpointLogLines);
        }

        private void populate(String basePath, Class<?> klass, boolean isLocator, Set<EndpointLogLine> endpointLogLines) {
            this.populate(basePath, klass, isLocator, Resource.from(klass), endpointLogLines);
        }

        private void populate(String basePath, Class<?> klass, boolean isLocator, Resource resource, Set<EndpointLogLine> endpointLogLines) {
            if (!isLocator) {
                basePath = this.normalizePath(basePath, resource.getPath());
            }
            for (ResourceMethod method : resource.getResourceMethods()) {
                endpointLogLines.add(new EndpointLogLine(method.getHttpMethod(), basePath, klass));
            }
            for (Resource childResource : resource.getChildResources()) {
                for (ResourceMethod method : childResource.getAllMethods()) {
                    String path;
                    if (method.getType() == ResourceMethod.JaxrsType.RESOURCE_METHOD) {
                        path = this.normalizePath(basePath, childResource.getPath());
                        endpointLogLines.add(new EndpointLogLine(method.getHttpMethod(), path, klass));
                        continue;
                    }
                    if (method.getType() != ResourceMethod.JaxrsType.SUB_RESOURCE_LOCATOR) continue;
                    path = this.normalizePath(basePath, childResource.getPath());
                    ResolvedType responseType = TYPE_RESOLVER.resolve(method.getInvocable().getResponseType(), new Type[0]);
                    Class<?> erasedType = !responseType.getTypeBindings().isEmpty() ? responseType.getTypeBindings().getBoundType(0).getErasedType() : responseType.getErasedType();
                    this.populate(path, erasedType, true, endpointLogLines);
                }
            }
        }

        private String normalizePath(String basePath, String path) {
            if (path == null) {
                return basePath;
            }
            if (basePath.endsWith("/")) {
                return path.startsWith("/") ? basePath + path.substring(1) : basePath + path;
            }
            return path.startsWith("/") ? basePath + path : basePath + "/" + path;
        }
    }
}

