/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.cli;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import io.dropwizard.cli.Command;
import io.dropwizard.configuration.ConfigurationException;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.util.JarLocation;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class Cli {
    private static final String COMMAND_NAME_ATTR = "command";
    private static final String[][] HELP = new String[][]{new String[0], {"-h"}, {"--help"}};
    private static final String[][] VERSION = new String[][]{{"-v"}, {"--version"}};
    private final PrintWriter stdOut;
    private final PrintWriter stdErr;
    private final SortedMap<String, Command> commands;
    private final Bootstrap<?> bootstrap;
    private final ArgumentParser parser;

    public Cli(JarLocation location, Bootstrap<?> bootstrap, OutputStream stdOut, OutputStream stdErr) {
        this.stdOut = new PrintWriter((Writer)new OutputStreamWriter(stdOut, Charsets.UTF_8), true);
        this.stdErr = new PrintWriter((Writer)new OutputStreamWriter(stdErr, Charsets.UTF_8), true);
        this.commands = Maps.newTreeMap();
        this.parser = this.buildParser(location);
        this.bootstrap = bootstrap;
        for (Command command : bootstrap.getCommands()) {
            this.addCommand(command);
        }
    }

    public boolean run(String ... arguments) throws Exception {
        try {
            if (this.isFlag(HELP, arguments)) {
                this.parser.printHelp(this.stdOut);
            } else if (this.isFlag(VERSION, arguments)) {
                this.parser.printVersion(this.stdOut);
            } else {
                Namespace namespace = this.parser.parseArgs(arguments);
                if (namespace.get("is-help") == null) {
                    Command command = (Command)this.commands.get(namespace.getString(COMMAND_NAME_ATTR));
                    command.run(this.bootstrap, namespace);
                }
            }
            return true;
        }
        catch (ArgumentParserException e) {
            this.stdErr.println(e.getMessage());
            e.getParser().printHelp(this.stdErr);
            return false;
        }
        catch (ConfigurationException e) {
            this.stdErr.println(e.getMessage());
            return false;
        }
    }

    private boolean isFlag(String[][] flags, String[] arguments) {
        for (Object[] objectArray : flags) {
            if (!Arrays.equals(arguments, objectArray)) continue;
            return true;
        }
        return false;
    }

    private ArgumentParser buildParser(JarLocation location) {
        String usage = "java -jar " + location;
        ArgumentParser p = ArgumentParsers.newArgumentParser(usage, false);
        p.version(location.getVersion().or("No application version detected. Add a Implementation-Version entry to your JAR's manifest to enable this."));
        this.addHelp(p);
        p.addArgument("-v", "--version").action(Arguments.help()).help("show the application version and exit");
        return p;
    }

    private void addHelp(ArgumentParser p) {
        p.addArgument("-h", "--help").action(new SafeHelpAction(this.stdOut)).help("show this help message and exit").setDefault(Arguments.SUPPRESS);
    }

    private void addCommand(Command command) {
        this.commands.put(command.getName(), command);
        this.parser.addSubparsers().help("available commands");
        Subparser subparser = this.parser.addSubparsers().addParser(command.getName(), false);
        command.configure(subparser);
        this.addHelp(subparser);
        subparser.description(command.getDescription()).setDefault(COMMAND_NAME_ATTR, command.getName()).defaultHelp(true);
    }

    private static class SafeHelpAction
    implements ArgumentAction {
        private final PrintWriter out;

        SafeHelpAction(PrintWriter out) {
            this.out = out;
        }

        @Override
        public void run(ArgumentParser parser, Argument arg, Map<String, Object> attrs, String flag, Object value) throws ArgumentParserException {
            parser.printHelp(this.out);
            attrs.put("is-help", Boolean.TRUE);
        }

        @Override
        public boolean consumeArgument() {
            return false;
        }

        @Override
        public void onAttach(Argument arg) {
        }
    }
}

