/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BeanPropertyMutator {
    protected final SettableBeanProperty originalMutator;
    protected final int index;
    private boolean broken = false;

    protected BeanPropertyMutator() {
        this(null, -1);
    }

    protected BeanPropertyMutator(SettableBeanProperty origM, int ix) {
        this.originalMutator = origM;
        this.index = ix;
    }

    public abstract BeanPropertyMutator with(SettableBeanProperty var1, int var2);

    public void intSetter(Object bean, int value) throws IOException {
        if (this.broken) {
            this.originalMutator.set(bean, value);
            return;
        }
        try {
            this.intSetter(bean, this.index, value);
            return;
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, value, e);
            return;
        }
        catch (SecurityException e) {
            this._reportProblem(bean, value, e);
            return;
        }
    }

    public void longSetter(Object bean, long value) throws IOException {
        if (this.broken) {
            this.originalMutator.set(bean, value);
            return;
        }
        try {
            this.longSetter(bean, this.index, value);
            return;
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, value, e);
            return;
        }
        catch (SecurityException e) {
            this._reportProblem(bean, value, e);
            return;
        }
    }

    public void booleanSetter(Object bean, boolean value) throws IOException {
        if (this.broken) {
            this.originalMutator.set(bean, value);
            return;
        }
        try {
            this.booleanSetter(bean, this.index, value);
            return;
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, value, e);
            return;
        }
        catch (SecurityException e) {
            this._reportProblem(bean, value, e);
            return;
        }
    }

    public void stringSetter(Object bean, String value) throws IOException {
        if (this.broken) {
            this.originalMutator.set(bean, value);
            return;
        }
        try {
            this.stringSetter(bean, this.index, value);
            return;
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, value, e);
            return;
        }
        catch (SecurityException e) {
            this._reportProblem(bean, value, e);
            return;
        }
    }

    public void objectSetter(Object bean, Object value) throws IOException {
        if (this.broken) {
            this.originalMutator.set(bean, value);
            return;
        }
        try {
            this.objectSetter(bean, this.index, value);
            return;
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, value, e);
            return;
        }
        catch (SecurityException e) {
            this._reportProblem(bean, value, e);
            return;
        }
    }

    public void intField(Object bean, int value) throws IOException {
        if (this.broken) {
            this.originalMutator.set(bean, value);
            return;
        }
        try {
            this.intField(bean, this.index, value);
            return;
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, value, e);
            return;
        }
        catch (SecurityException e) {
            this._reportProblem(bean, value, e);
            return;
        }
    }

    public void longField(Object bean, long value) throws IOException {
        if (this.broken) {
            this.originalMutator.set(bean, value);
            return;
        }
        try {
            this.longField(bean, this.index, value);
            return;
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, value, e);
            return;
        }
        catch (SecurityException e) {
            this._reportProblem(bean, value, e);
            return;
        }
    }

    public void booleanField(Object bean, boolean value) throws IOException {
        if (this.broken) {
            this.originalMutator.set(bean, value);
            return;
        }
        try {
            this.booleanField(bean, this.index, value);
            return;
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, value, e);
            return;
        }
        catch (SecurityException e) {
            this._reportProblem(bean, value, e);
            return;
        }
    }

    public void stringField(Object bean, String value) throws IOException {
        if (this.broken) {
            this.originalMutator.set(bean, value);
            return;
        }
        try {
            this.stringField(bean, this.index, value);
            return;
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, value, e);
            return;
        }
        catch (SecurityException e) {
            this._reportProblem(bean, value, e);
            return;
        }
    }

    public void objectField(Object bean, Object value) throws IOException {
        if (this.broken) {
            this.originalMutator.set(bean, value);
            return;
        }
        try {
            this.objectField(bean, this.index, value);
            return;
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, value, e);
            return;
        }
        catch (SecurityException e) {
            this._reportProblem(bean, value, e);
            return;
        }
    }

    protected void intSetter(Object bean, int propertyIndex, int value) {
        throw new UnsupportedOperationException("No intSetters defined");
    }

    protected void longSetter(Object bean, int propertyIndex, long value) {
        throw new UnsupportedOperationException("No longSetters defined");
    }

    protected void booleanSetter(Object bean, int propertyIndex, boolean value) {
        throw new UnsupportedOperationException("No booleanSetters defined");
    }

    protected void stringSetter(Object bean, int propertyIndex, String value) {
        throw new UnsupportedOperationException("No stringSetters defined");
    }

    protected void objectSetter(Object bean, int propertyIndex, Object value) {
        throw new UnsupportedOperationException("No objectSetters defined");
    }

    protected void intField(Object bean, int propertyIndex, int value) {
        throw new UnsupportedOperationException("No intFields defined");
    }

    protected void longField(Object bean, int propertyIndex, long value) {
        throw new UnsupportedOperationException("No longFields defined");
    }

    protected void booleanField(Object bean, int propertyIndex, boolean value) {
        throw new UnsupportedOperationException("No booleanFields defined");
    }

    protected void stringField(Object bean, int propertyIndex, String value) {
        throw new UnsupportedOperationException("No stringFields defined");
    }

    protected void objectField(Object bean, int propertyIndex, Object value) {
        throw new UnsupportedOperationException("No objectFields defined");
    }

    private synchronized void _reportProblem(Object bean, Object value, Throwable e) throws IOException {
        if (!this.broken) {
            this.broken = true;
            String msg = String.format("Disabling Afterburner deserialization for %s (field #%d; mutator %s), due to access error (type %s, message=%s)%n", bean.getClass(), this.index, this.getClass().getName(), e.getClass().getName(), e.getMessage());
            Logger.getLogger(BeanPropertyMutator.class.getName()).log(Level.WARNING, msg, e);
        }
        this.originalMutator.set(bean, value);
    }
}

