/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import java.io.IOException;
import org.joda.time.LocalDateTime;

public class LocalDateTimeSerializer
extends JodaDateSerializerBase<LocalDateTime> {
    private static final long serialVersionUID = 1L;

    public LocalDateTimeSerializer() {
        this(FormatConfig.DEFAULT_LOCAL_DATETIME_PRINTER);
    }

    public LocalDateTimeSerializer(JacksonJodaDateFormat format) {
        super(LocalDateTime.class, format, true, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    public LocalDateTimeSerializer withFormat(JacksonJodaDateFormat formatter) {
        return this._format == formatter ? this : new LocalDateTimeSerializer(formatter);
    }

    @Override
    public void serialize(LocalDateTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._useTimestamp(provider)) {
            gen.writeStartArray();
            gen.writeNumber(value.year().get());
            gen.writeNumber(value.monthOfYear().get());
            gen.writeNumber(value.dayOfMonth().get());
            gen.writeNumber(value.hourOfDay().get());
            gen.writeNumber(value.minuteOfHour().get());
            gen.writeNumber(value.secondOfMinute().get());
            gen.writeNumber(value.millisOfSecond().get());
            gen.writeEndArray();
        } else {
            gen.writeString(this._format.createFormatter(provider).print(value));
        }
    }
}

