/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.servlets;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.util.JSONPObject;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MetricsServlet
extends HttpServlet {
    public static final String RATE_UNIT = MetricsServlet.class.getCanonicalName() + ".rateUnit";
    public static final String DURATION_UNIT = MetricsServlet.class.getCanonicalName() + ".durationUnit";
    public static final String SHOW_SAMPLES = MetricsServlet.class.getCanonicalName() + ".showSamples";
    public static final String METRICS_REGISTRY = MetricsServlet.class.getCanonicalName() + ".registry";
    public static final String ALLOWED_ORIGIN = MetricsServlet.class.getCanonicalName() + ".allowedOrigin";
    public static final String METRIC_FILTER = MetricsServlet.class.getCanonicalName() + ".metricFilter";
    public static final String CALLBACK_PARAM = MetricsServlet.class.getCanonicalName() + ".jsonpCallback";
    private static final long serialVersionUID = 1049773947734939602L;
    private static final String CONTENT_TYPE = "application/json";
    private String allowedOrigin;
    private String jsonpParamName;
    private transient MetricRegistry registry;
    private transient ObjectMapper mapper;

    public MetricsServlet() {
    }

    public MetricsServlet(MetricRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext context = config.getServletContext();
        if (null == this.registry) {
            Object registryAttr = context.getAttribute(METRICS_REGISTRY);
            if (registryAttr instanceof MetricRegistry) {
                this.registry = (MetricRegistry)registryAttr;
            } else {
                throw new ServletException("Couldn't find a MetricRegistry instance.");
            }
        }
        TimeUnit rateUnit = this.parseTimeUnit(context.getInitParameter(RATE_UNIT), TimeUnit.SECONDS);
        TimeUnit durationUnit = this.parseTimeUnit(context.getInitParameter(DURATION_UNIT), TimeUnit.SECONDS);
        boolean showSamples = Boolean.parseBoolean(context.getInitParameter(SHOW_SAMPLES));
        MetricFilter filter = (MetricFilter)context.getAttribute(METRIC_FILTER);
        if (filter == null) {
            filter = MetricFilter.ALL;
        }
        this.mapper = new ObjectMapper().registerModule(new MetricsModule(rateUnit, durationUnit, showSamples, filter));
        this.allowedOrigin = context.getInitParameter(ALLOWED_ORIGIN);
        this.jsonpParamName = context.getInitParameter(CALLBACK_PARAM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType(CONTENT_TYPE);
        if (this.allowedOrigin != null) {
            resp.setHeader("Access-Control-Allow-Origin", this.allowedOrigin);
        }
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        resp.setStatus(200);
        ServletOutputStream output = resp.getOutputStream();
        try {
            if (this.jsonpParamName != null && req.getParameter(this.jsonpParamName) != null) {
                this.getWriter(req).writeValue(output, (Object)new JSONPObject(req.getParameter(this.jsonpParamName), this.registry));
            } else {
                this.getWriter(req).writeValue(output, (Object)this.registry);
            }
        }
        finally {
            output.close();
        }
    }

    private ObjectWriter getWriter(HttpServletRequest request) {
        boolean prettyPrint = Boolean.parseBoolean(request.getParameter("pretty"));
        if (prettyPrint) {
            return this.mapper.writerWithDefaultPrettyPrinter();
        }
        return this.mapper.writer();
    }

    private TimeUnit parseTimeUnit(String value, TimeUnit defaultValue) {
        try {
            return TimeUnit.valueOf(String.valueOf(value).toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static abstract class ContextListener
    implements ServletContextListener {
        protected abstract MetricRegistry getMetricRegistry();

        protected TimeUnit getRateUnit() {
            return null;
        }

        protected TimeUnit getDurationUnit() {
            return null;
        }

        protected String getAllowedOrigin() {
            return null;
        }

        protected String getJsonpCallbackParameter() {
            return null;
        }

        protected MetricFilter getMetricFilter() {
            return MetricFilter.ALL;
        }

        @Override
        public void contextInitialized(ServletContextEvent event) {
            ServletContext context = event.getServletContext();
            context.setAttribute(METRICS_REGISTRY, this.getMetricRegistry());
            context.setAttribute(METRIC_FILTER, this.getMetricFilter());
            if (this.getDurationUnit() != null) {
                context.setInitParameter(DURATION_UNIT, this.getDurationUnit().toString());
            }
            if (this.getRateUnit() != null) {
                context.setInitParameter(RATE_UNIT, this.getRateUnit().toString());
            }
            if (this.getAllowedOrigin() != null) {
                context.setInitParameter(ALLOWED_ORIGIN, this.getAllowedOrigin());
            }
            if (this.getJsonpCallbackParameter() != null) {
                context.setAttribute(CALLBACK_PARAM, this.getJsonpCallbackParameter());
            }
        }

        @Override
        public void contextDestroyed(ServletContextEvent event) {
        }
    }
}

