/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.mutableconfig.propertysources;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.mutableconfig.propertysources.AbstractMutablePropertySource;
import org.apache.tamaya.mutableconfig.propertysources.ConfigChangeContext;
import org.apache.tamaya.spi.PropertyValue;
import org.apache.tamaya.spi.PropertyValueBuilder;

public class MutableXmlPropertiesPropertySource
extends AbstractMutablePropertySource {
    private static final Logger LOG = Logger.getLogger(MutableXmlPropertiesPropertySource.class.getName());
    private static final long DEFAULT_UPDATE_INTERVAL = 60000L;
    private String name;
    private File file;
    private long lastRead;
    private long updateInterval = 60000L;
    private Map<String, String> properties = new HashMap<String, String>();

    public MutableXmlPropertiesPropertySource(File propertiesLocation, int defaultOrdinal) {
        super(defaultOrdinal);
        this.name = propertiesLocation.toString();
        try {
            this.file = propertiesLocation;
            this.load();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Cannot convert file to URL: " + propertiesLocation, e);
        }
    }

    public PropertyValue get(String key) {
        Map<String, String> properties = this.getProperties();
        String val = properties.get(key);
        if (val == null) {
            return null;
        }
        PropertyValueBuilder b = new PropertyValueBuilder(key, val, this.getName());
        String metaKeyStart = "_" + key + ".";
        for (Map.Entry<String, String> en : properties.entrySet()) {
            if (!en.getKey().startsWith(metaKeyStart)) continue;
            b.addContextData(en.getKey().substring(metaKeyStart.length()), (Object)en.getValue());
        }
        return b.build();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        this.checkLoad();
        return Collections.unmodifiableMap(this.properties);
    }

    private void checkLoad() {
        if (this.file != null && this.lastRead + this.updateInterval < System.currentTimeMillis()) {
            this.load();
        }
    }

    private void load() {
        try (FileInputStream stream = new FileInputStream(this.file);){
            HashMap<String, String> properties = new HashMap<String, String>();
            Properties props = new Properties();
            props.loadFromXML(stream);
            for (String key : props.stringPropertyNames()) {
                properties.put(key, props.getProperty(key));
            }
            this.lastRead = System.currentTimeMillis();
            this.properties = properties;
            LOG.log(Level.FINEST, "Loaded properties from " + this.file);
            this.properties = properties;
        }
        catch (IOException e) {
            LOG.log(Level.FINEST, "Cannot load properties from " + this.file, e);
        }
    }

    @Override
    protected void commitInternal(ConfigChangeContext context) {
        if (context.isEmpty()) {
            LOG.info("Nothing to commit for transaction: " + context.getTransactionID());
            return;
        }
        if (!this.file.exists()) {
            try {
                if (!this.file.createNewFile()) {
                    throw new ConfigException("Failed to create config file " + this.file);
                }
            }
            catch (IOException e) {
                throw new ConfigException("Failed to create config file " + this.file, (Throwable)e);
            }
        }
        for (Map.Entry<String, String> en : context.getAddedProperties().entrySet()) {
            int index = en.getKey().indexOf(63);
            if (index > 0) {
                this.properties.put(en.getKey().substring(0, index), en.getValue());
                continue;
            }
            this.properties.put(en.getKey(), en.getValue());
        }
        for (String rmKey : context.getRemovedProperties()) {
            this.properties.remove(rmKey);
        }
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.file));){
            Properties props = new Properties();
            for (Map.Entry<String, String> en : this.properties.entrySet()) {
                props.setProperty(en.getKey(), en.getValue());
            }
            props.storeToXML(bos, "Properties written from Tamaya on " + new Date());
            bos.flush();
        }
        catch (Exception e) {
            throw new ConfigException("Failed to write config to " + this.file, (Throwable)e);
        }
    }
}

