/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.mutableconfig.propertysources;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public final class ConfigChangeContext {
    private UUID transactionId;
    private long startedAt = System.currentTimeMillis();
    private final Map<String, String> addedProperties = new HashMap<String, String>();
    private final Set<String> removedProperties = new HashSet<String>();

    public ConfigChangeContext(UUID transactionID) {
        this.transactionId = Objects.requireNonNull(transactionID);
    }

    public UUID getTransactionID() {
        return this.transactionId;
    }

    public long getStartedAt() {
        return this.startedAt;
    }

    public Map<String, String> getAddedProperties() {
        return Collections.unmodifiableMap(this.addedProperties);
    }

    public Set<String> getRemovedProperties() {
        return Collections.unmodifiableSet(this.removedProperties);
    }

    public void put(String key, String value) {
        this.addedProperties.put(key, value);
    }

    public void putAll(Map<String, String> properties) {
        this.addedProperties.putAll(properties);
    }

    public void removeAll(Collection<String> keys) {
        this.removedProperties.addAll(keys);
    }

    public boolean isEmpty() {
        return this.addedProperties.isEmpty() && this.removedProperties.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigChangeContext)) {
            return false;
        }
        ConfigChangeContext that = (ConfigChangeContext)o;
        return this.transactionId.equals(that.transactionId);
    }

    public int hashCode() {
        return this.transactionId.hashCode();
    }

    public String toString() {
        return "TransactionContext{addedProperties=" + this.addedProperties + ", transactionId=" + this.transactionId + ", startedAt=" + this.startedAt + ", removedProperties=" + this.removedProperties + '}';
    }
}

