/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.mutableconfig.propertysources;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tamaya.mutableconfig.propertysources.ConfigChangeContext;
import org.apache.tamaya.mutableconfig.spi.MutablePropertySource;
import org.apache.tamaya.spisupport.BasePropertySource;

public abstract class AbstractMutablePropertySource
extends BasePropertySource
implements MutablePropertySource {
    protected final Map<UUID, ConfigChangeContext> transactions = new ConcurrentHashMap<UUID, ConfigChangeContext>();

    protected AbstractMutablePropertySource() {
    }

    protected AbstractMutablePropertySource(int defaultOrdinal) {
        super(defaultOrdinal);
    }

    protected final Set<String> getRemovedProperties(UUID transactionId) {
        ConfigChangeContext ctx = this.transactions.get(transactionId);
        if (ctx != null) {
            return ctx.getRemovedProperties();
        }
        return Collections.emptySet();
    }

    protected final Map<String, String> getAddedProperties(UUID transactionId) {
        ConfigChangeContext ctx = this.transactions.get(transactionId);
        if (ctx != null) {
            return ctx.getAddedProperties();
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean isWritable(String keyExpression) {
        return true;
    }

    @Override
    public boolean isRemovable(String keyExpression) {
        return true;
    }

    @Override
    public final MutablePropertySource put(UUID transactionId, String key, String value) {
        ConfigChangeContext ctx = this.transactions.get(transactionId);
        if (ctx == null) {
            throw new IllegalStateException("No such transaction: " + transactionId);
        }
        ctx.put(key, value);
        return this;
    }

    @Override
    public final MutablePropertySource putAll(UUID transactionId, Map<String, String> properties) {
        ConfigChangeContext ctx = this.transactions.get(transactionId);
        if (ctx == null) {
            throw new IllegalStateException("No such transaction: " + transactionId);
        }
        ctx.putAll(properties);
        return this;
    }

    @Override
    public final MutablePropertySource remove(UUID transactionId, String ... keys) {
        ConfigChangeContext ctx = this.transactions.get(transactionId);
        if (ctx == null) {
            throw new IllegalStateException("No such transaction: " + transactionId);
        }
        ctx.removeAll(Arrays.asList(keys));
        return this;
    }

    @Override
    public final MutablePropertySource remove(UUID transactionId, Collection<String> keys) {
        ConfigChangeContext ctx = this.transactions.get(transactionId);
        if (ctx == null) {
            throw new IllegalStateException("No such transaction: " + transactionId);
        }
        ctx.removeAll(keys);
        return this;
    }

    @Override
    public final void startTransaction(UUID transactionId) {
        ConfigChangeContext ctx = this.transactions.get(transactionId);
        if (ctx == null) {
            this.transactions.put(transactionId, new ConfigChangeContext(transactionId));
        }
    }

    @Override
    public final void commitTransaction(UUID transactionId) {
        ConfigChangeContext ctx = this.transactions.remove(transactionId);
        if (ctx == null) {
            throw new IllegalStateException("No such transaction: " + transactionId);
        }
        this.commitInternal(ctx);
    }

    protected abstract void commitInternal(ConfigChangeContext var1);

    @Override
    public final void rollbackTransaction(UUID transactionId) {
        this.transactions.remove(transactionId);
    }
}

