/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.mutableconfig.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigOperator;
import org.apache.tamaya.ConfigQuery;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.mutableconfig.ChangePropagationPolicy;
import org.apache.tamaya.mutableconfig.MutableConfiguration;
import org.apache.tamaya.mutableconfig.MutableConfigurationProvider;
import org.apache.tamaya.mutableconfig.spi.MutablePropertySource;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.PropertySource;

public class DefaultMutableConfiguration
implements MutableConfiguration {
    private static final Logger LOG = Logger.getLogger(DefaultMutableConfiguration.class.getName());
    private final Configuration config;
    private ChangePropagationPolicy changePropagationPolicy = MutableConfigurationProvider.getApplyAllChangePolicy();
    private UUID transactionId;
    private boolean autoCommit = false;

    public DefaultMutableConfiguration(Configuration config) {
        this.config = Objects.requireNonNull(config);
        this.autoCommit = false;
    }

    @Override
    public void setChangePropagationPolicy(ChangePropagationPolicy changePropagationPolicy) {
        this.changePropagationPolicy = Objects.requireNonNull(changePropagationPolicy);
    }

    @Override
    public ChangePropagationPolicy getChangePropagationPolicy() {
        return this.changePropagationPolicy;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        if (this.transactionId != null) {
            throw new IllegalStateException("Cannot change autoCommit within a transaction, perform a commit or rollback first.");
        }
        this.autoCommit = autoCommit;
    }

    @Override
    public UUID getTransactionId() {
        return this.transactionId;
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public List<MutablePropertySource> getMutablePropertySources() {
        ArrayList<MutablePropertySource> result = new ArrayList<MutablePropertySource>();
        for (PropertySource propertySource : this.config.getContext().getPropertySources()) {
            if (!(propertySource instanceof MutablePropertySource)) continue;
            result.add((MutablePropertySource)propertySource);
        }
        return result;
    }

    @Override
    public boolean isWritable(String keyExpression) {
        for (MutablePropertySource target : this.getMutablePropertySources()) {
            if (!target.isWritable(keyExpression)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<MutablePropertySource> getPropertySourcesThatCanWrite(String keyExpression) {
        ArrayList<MutablePropertySource> result = new ArrayList<MutablePropertySource>();
        for (MutablePropertySource propertySource : this.getMutablePropertySources()) {
            if (!propertySource.isWritable(keyExpression)) continue;
            result.add(propertySource);
        }
        return result;
    }

    @Override
    public boolean isRemovable(String keyExpression) {
        for (MutablePropertySource target : this.getMutablePropertySources()) {
            if (!target.isRemovable(keyExpression)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<MutablePropertySource> getPropertySourcesThatCanRemove(String keyExpression) {
        ArrayList<MutablePropertySource> result = new ArrayList<MutablePropertySource>();
        for (MutablePropertySource propertySource : this.getMutablePropertySources()) {
            if (!propertySource.isRemovable(keyExpression)) continue;
            result.add(propertySource);
        }
        return result;
    }

    @Override
    public boolean isExisting(String keyExpression) {
        for (MutablePropertySource target : this.getMutablePropertySources()) {
            if (target.get(keyExpression) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<MutablePropertySource> getPropertySourcesThatKnow(String keyExpression) {
        ArrayList<MutablePropertySource> result = new ArrayList<MutablePropertySource>();
        for (MutablePropertySource propertySource : this.getMutablePropertySources()) {
            if (propertySource.get(keyExpression) == null) continue;
            result.add(propertySource);
        }
        return result;
    }

    @Override
    public MutableConfiguration put(String key, String value) {
        UUID taID = this.startTransaction();
        this.changePropagationPolicy.applyChange(this.getPropertySources(), taID, key, value);
        if (this.autoCommit) {
            this.commitTransaction();
        }
        return this;
    }

    @Override
    public MutableConfiguration putAll(Map<String, String> properties) {
        UUID taID = this.startTransaction();
        this.changePropagationPolicy.applyChanges(this.getPropertySources(), taID, properties);
        if (this.autoCommit) {
            this.commitTransaction();
        }
        return this;
    }

    @Override
    public MutableConfiguration remove(String ... keys) {
        UUID taID = this.startTransaction();
        this.changePropagationPolicy.applyRemove(this.getPropertySources(), taID, keys);
        for (String key : keys) {
            for (MutablePropertySource target : this.getMutablePropertySources()) {
                if (!target.isRemovable(key)) continue;
                target.remove(taID, key);
            }
        }
        if (this.autoCommit) {
            this.commitTransaction();
        }
        return this;
    }

    @Override
    public UUID startTransaction() {
        UUID taID = this.transactionId;
        if (taID != null) {
            return taID;
        }
        this.transactionId = taID = UUID.randomUUID();
        try {
            for (MutablePropertySource target : this.getMutablePropertySources()) {
                target.startTransaction(taID);
            }
        }
        catch (Exception e) {
            this.rollbackTransaction();
        }
        return taID;
    }

    @Override
    public void commitTransaction() {
        UUID taID = this.transactionId;
        if (taID == null) {
            LOG.warning("No active transaction on this thread, ignoring commit.");
            return;
        }
        try {
            for (MutablePropertySource target : this.getMutablePropertySources()) {
                target.commitTransaction(taID);
            }
            this.transactionId = null;
        }
        catch (Exception e) {
            this.rollbackTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackTransaction() {
        UUID taID = this.transactionId;
        if (taID == null) {
            LOG.warning("No active transaction on this thread, ignoring rollback.");
            return;
        }
        try {
            for (MutablePropertySource target : this.getMutablePropertySources()) {
                target.rollbackTransaction(taID);
            }
        }
        finally {
            this.transactionId = null;
        }
    }

    @Override
    public MutableConfiguration remove(Collection<String> keys) {
        UUID taID = this.startTransaction();
        for (String key : keys) {
            for (MutablePropertySource target : this.getMutablePropertySources()) {
                if (!target.isRemovable(key)) continue;
                target.remove(taID, key);
            }
        }
        if (this.autoCommit) {
            this.commitTransaction();
        }
        return this;
    }

    public String get(String key) {
        return this.config.get(key);
    }

    public String getOrDefault(String key, String defaultValue) {
        return this.config.getOrDefault(key, defaultValue);
    }

    public <T> T getOrDefault(String key, Class<T> type, T defaultValue) {
        return (T)this.config.getOrDefault(key, type, defaultValue);
    }

    public <T> T get(String key, Class<T> type) {
        return (T)this.config.get(key, type);
    }

    public <T> T get(String key, TypeLiteral<T> type) {
        return (T)this.config.get(key, type);
    }

    public <T> T getOrDefault(String key, TypeLiteral<T> type, T defaultValue) {
        return (T)this.config.getOrDefault(key, type, defaultValue);
    }

    public Map<String, String> getProperties() {
        return this.config.getProperties();
    }

    public Configuration with(ConfigOperator operator) {
        return operator.operate((Configuration)this);
    }

    public <T> T query(ConfigQuery<T> query) {
        return (T)query.query((Configuration)this);
    }

    public ConfigurationContext getContext() {
        return this.config.getContext();
    }

    private Collection<PropertySource> getPropertySources() {
        return this.config.getContext().getPropertySources();
    }

    public String toString() {
        return "DefaultMutableConfiguration{config=" + this.config + ", autoCommit=" + this.autoCommit + '}';
    }
}

