/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.mutableconfig;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.mutableconfig.ChangePropagationPolicy;
import org.apache.tamaya.mutableconfig.MutableConfiguration;
import org.apache.tamaya.mutableconfig.spi.MutableConfigurationProviderSpi;
import org.apache.tamaya.mutableconfig.spi.MutablePropertySource;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.ServiceContextManager;

public final class MutableConfigurationProvider {
    private static final Logger LOG = Logger.getLogger(MutableConfigurationProvider.class.getName());
    private static MutableConfigurationProviderSpi mutableConfigurationProviderSpi = MutableConfigurationProvider.loadSpi();
    private static final ChangePropagationPolicy ALL_POLICY = new ChangePropagationPolicy(){

        @Override
        public void applyChanges(Collection<PropertySource> propertySources, UUID transactionID, Map<String, String> changes) {
            for (PropertySource propertySource : propertySources) {
                if (!(propertySource instanceof MutablePropertySource)) continue;
                MutablePropertySource target = (MutablePropertySource)propertySource;
                for (Map.Entry<String, String> en : changes.entrySet()) {
                    if (!target.isWritable(en.getKey())) continue;
                    target.put(transactionID, en.getKey(), en.getValue());
                }
            }
        }

        @Override
        public void applyChange(Collection<PropertySource> propertySources, UUID transactionID, String key, String value) {
            for (PropertySource propertySource : propertySources) {
                MutablePropertySource target;
                if (!(propertySource instanceof MutablePropertySource) || !(target = (MutablePropertySource)propertySource).isWritable(key)) continue;
                target.put(transactionID, key, value);
            }
        }

        @Override
        public void applyRemove(Collection<PropertySource> propertySources, UUID transactionID, String ... keys) {
            for (PropertySource propertySource : propertySources) {
                if (!(propertySource instanceof MutablePropertySource)) continue;
                MutablePropertySource target = (MutablePropertySource)propertySource;
                for (String key : keys) {
                    if (!target.isRemovable(key)) continue;
                    target.remove(transactionID, key);
                }
            }
        }
    };
    private static final ChangePropagationPolicy MOST_SIGNIFICANT_ONLY_POLICY = new ChangePropagationPolicy(){

        @Override
        public void applyChanges(Collection<PropertySource> propertySources, UUID transactionID, Map<String, String> changes) {
            block0: for (Map.Entry<String, String> en : changes.entrySet()) {
                for (PropertySource propertySource : propertySources) {
                    MutablePropertySource target;
                    if (!(propertySource instanceof MutablePropertySource) || !(target = (MutablePropertySource)propertySource).isWritable(en.getKey())) continue;
                    target.put(transactionID, en.getKey(), en.getValue());
                    continue block0;
                }
            }
        }

        @Override
        public void applyChange(Collection<PropertySource> propertySources, UUID transactionID, String key, String value) {
            for (PropertySource propertySource : propertySources) {
                MutablePropertySource target;
                if (!(propertySource instanceof MutablePropertySource) || !(target = (MutablePropertySource)propertySource).isWritable(key)) continue;
                target.put(transactionID, key, value);
                return;
            }
        }

        @Override
        public void applyRemove(Collection<PropertySource> propertySources, UUID transactionID, String ... keys) {
            block0: for (String key : keys) {
                for (PropertySource propertySource : propertySources) {
                    MutablePropertySource target;
                    if (!(propertySource instanceof MutablePropertySource) || !(target = (MutablePropertySource)propertySource).isRemovable(key)) continue;
                    target.remove(transactionID, key);
                    continue block0;
                }
            }
        }
    };
    private static final ChangePropagationPolicy NONE_POLICY = new ChangePropagationPolicy(){

        @Override
        public void applyChanges(Collection<PropertySource> propertySources, UUID transactionID, Map<String, String> changes) {
        }

        @Override
        public void applyChange(Collection<PropertySource> propertySources, UUID transactionID, String key, String value) {
        }

        @Override
        public void applyRemove(Collection<PropertySource> propertySources, UUID transactionID, String ... keys) {
        }
    };

    private static MutableConfigurationProviderSpi loadSpi() {
        try {
            return (MutableConfigurationProviderSpi)ServiceContextManager.getServiceContext().getService(MutableConfigurationProviderSpi.class);
        }
        catch (Exception e) {
            throw new ConfigException("Failed to initialize MutableConfigurationProviderSpi - mutable configuration support.");
        }
    }

    private MutableConfigurationProvider() {
    }

    public static MutableConfiguration getMutableConfiguration() {
        return mutableConfigurationProviderSpi.createMutableConfiguration(ConfigurationProvider.getConfiguration());
    }

    public static MutableConfiguration getMutableConfiguration(Configuration configuration) {
        return mutableConfigurationProviderSpi.createMutableConfiguration(configuration);
    }

    public static ChangePropagationPolicy getApplyAllChangePolicy() {
        return ALL_POLICY;
    }

    public static ChangePropagationPolicy getApplyMostSignificantOnlyChangePolicy() {
        return MOST_SIGNIFICANT_ONLY_POLICY;
    }

    public static ChangePropagationPolicy getApplySelectiveChangePolicy(String ... propertySourceNames) {
        return new SelectiveChangeApplyPolicy(propertySourceNames);
    }

    public static ChangePropagationPolicy getApplyNonePolicy() {
        return NONE_POLICY;
    }

    private static final class SelectiveChangeApplyPolicy
    implements ChangePropagationPolicy {
        private Set<String> propertySourceNames = new HashSet<String>();

        SelectiveChangeApplyPolicy(String ... propertySourceNames) {
            this.propertySourceNames.addAll(Arrays.asList(propertySourceNames));
        }

        @Override
        public void applyChanges(Collection<PropertySource> propertySources, UUID transactionID, Map<String, String> changes) {
            for (PropertySource propertySource : propertySources) {
                if (!(propertySource instanceof MutablePropertySource) || !this.propertySourceNames.contains(propertySource.getName())) continue;
                MutablePropertySource target = (MutablePropertySource)propertySource;
                for (Map.Entry<String, String> en : changes.entrySet()) {
                    if (!target.isWritable(en.getKey())) continue;
                    target.put(transactionID, en.getKey(), en.getValue());
                }
            }
        }

        @Override
        public void applyChange(Collection<PropertySource> propertySources, UUID transactionID, String key, String value) {
            for (PropertySource propertySource : propertySources) {
                MutablePropertySource target;
                if (!(propertySource instanceof MutablePropertySource) || !this.propertySourceNames.contains(propertySource.getName()) || !(target = (MutablePropertySource)propertySource).isWritable(key)) continue;
                target.put(transactionID, key, value);
            }
        }

        @Override
        public void applyRemove(Collection<PropertySource> propertySources, UUID transactionID, String ... keys) {
            for (PropertySource propertySource : propertySources) {
                if (!(propertySource instanceof MutablePropertySource) || !this.propertySourceNames.contains(propertySource.getName())) continue;
                MutablePropertySource target = (MutablePropertySource)propertySource;
                for (String key : keys) {
                    if (!target.isRemovable(key)) continue;
                    target.remove(transactionID, key);
                }
            }
        }
    }
}

