/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya;

import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class TypeLiteral<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    private final Type definedType;

    public TypeLiteral(Type definedType) {
        this.definedType = definedType;
    }

    public TypeLiteral() {
        this.definedType = this.getDefinedType(this.getClass());
    }

    public static <R> TypeLiteral<R> of(Type type) {
        return new TypeLiteral(type);
    }

    public static Type[] getGenericInterfaceTypeParameters(Class<?> clazz, Class<?> interfaceType) {
        for (Type type : clazz.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)type).getRawType().equals(interfaceType)) continue;
            return parameterizedType.getActualTypeArguments();
        }
        return EMPTY_TYPE_ARRAY;
    }

    public static Type[] getTypeParameters(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return parameterizedType.getActualTypeArguments();
        }
        return EMPTY_TYPE_ARRAY;
    }

    public final Type getType() {
        return this.definedType;
    }

    public final Class<T> getRawType() {
        Class rawType;
        if (this.definedType instanceof Class) {
            rawType = (Class)this.definedType;
        } else if (this.definedType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this.definedType;
            rawType = (Class)pt.getRawType();
        } else if (this.definedType instanceof GenericArrayType) {
            rawType = Object[].class;
        } else {
            throw new RuntimeException("Illegal type for the Type Literal Class");
        }
        return rawType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Type getDefinedType(Class<?> clazz) {
        if (clazz == null) {
            throw new RuntimeException("Class parameter clazz can not be null");
        }
        Type superClazz = clazz.getGenericSuperclass();
        if (superClazz instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)superClazz;
            Type[] actualArgs = pt.getActualTypeArguments();
            if (actualArgs.length != 1) throw new RuntimeException("More than one parametric type");
            return actualArgs[0];
        }
        if (!superClazz.equals(Object.class)) return this.getDefinedType((Class)superClazz);
        throw new RuntimeException("Super class must be parametrized type");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.definedType == null ? 0 : this.definedType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeLiteral other = (TypeLiteral)obj;
        return !(this.definedType == null ? other.definedType != null : !this.definedType.equals(other.definedType));
    }

    public String toString() {
        return "TypeLiteral{type=" + this.definedType + '}';
    }
}

