/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.ConfigurationContextBuilder;
import org.apache.tamaya.spi.ConfigurationProviderSpi;
import org.apache.tamaya.spi.ServiceContextManager;

public final class ConfigurationProvider {
    private static final ConfigurationProviderSpi PROVIDER_SPI = ConfigurationProvider.loadSpi();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConfigurationProviderSpi loadSpi() {
        ConfigurationProviderSpi spi = ServiceContextManager.getServiceContext().getService(ConfigurationProviderSpi.class);
        if (spi == null) {
            throw new IllegalStateException("ConfigurationProviderSpi not available.");
        }
        BufferedReader reader = null;
        try {
            URL url = ConfigurationProvider.class.getResource("/tamaya-banner.txt");
            if (url != null) {
                reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                StringBuilder b = new StringBuilder();
                String line = reader.readLine();
                while (line != null) {
                    b.append(line).append('\n');
                    line = reader.readLine();
                }
                System.out.println(b.toString());
            }
        }
        catch (Exception e) {
            System.out.println("************ TAMAYA CONFIG ************");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return spi;
    }

    private ConfigurationProvider() {
    }

    public static Configuration getConfiguration() {
        return PROVIDER_SPI.getConfiguration();
    }

    @Deprecated
    public static ConfigurationContext getConfigurationContext() {
        return PROVIDER_SPI.getConfigurationContext();
    }

    public static void setConfigurationContext(ConfigurationContext context) {
        PROVIDER_SPI.setConfigurationContext(context);
    }

    public static ConfigurationContextBuilder getConfigurationContextBuilder() {
        return PROVIDER_SPI.getConfigurationContextBuilder();
    }
}

