/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.tamaya.core.internal.converters;

import org.apache.tamaya.spi.PropertyConverter;

import java.time.LocalTime;
import java.util.Objects;

/**
 * Converter, converting from String to LocalTime.
 */
public class LocalTimeConverter implements PropertyConverter<LocalTime>{

    @Override
    public LocalTime convert(String value) {
        String trimmed = Objects.requireNonNull(value).trim();
        return LocalTime.parse(trimmed);
    }

    public static void main(String... args){
        LocalTime.parse("10:00");
        LocalTime.parse("10:00:23");
        LocalTime.parse("10");
    }
}
