/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.spi;

import java.util.Objects;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.spi.ServiceContext;

public final class ServiceContextManager {
    private static volatile ServiceContext serviceContextProviderDelegate;

    private ServiceContextManager() {
    }

    private static ServiceContext loadDefaultServiceProvider() {
        ServiceContext highestServiceContext = null;
        try {
            int highestOrdinal = 0;
            for (ServiceContext serviceContext : ServiceLoader.load(ServiceContext.class)) {
                if (serviceContext.ordinal() <= highestOrdinal) continue;
                highestServiceContext = serviceContext;
            }
        }
        catch (Exception e) {
            throw new ConfigException("ServiceContext not loadable", e);
        }
        if (highestServiceContext == null) {
            throw new ConfigException("No ServiceContext found");
        }
        return highestServiceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceContext set(ServiceContext serviceContextProvider) {
        ServiceContext currentContext = serviceContextProviderDelegate;
        Objects.requireNonNull(serviceContextProvider);
        Class<ServiceContextManager> clazz = ServiceContextManager.class;
        synchronized (ServiceContextManager.class) {
            if (serviceContextProviderDelegate == null) {
                serviceContextProviderDelegate = serviceContextProvider;
                Logger.getLogger(ServiceContextManager.class.getName()).log(Level.INFO, "Using ServiceProvider: " + serviceContextProvider.getClass().getName());
            } else {
                Logger.getLogger(ServiceContextManager.class.getName()).log(Level.WARNING, "Replacing ServiceProvider " + serviceContextProviderDelegate.getClass().getName() + " with: " + serviceContextProvider.getClass().getName());
                serviceContextProviderDelegate = serviceContextProvider;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return currentContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceContext getServiceContext() {
        if (serviceContextProviderDelegate != null) return serviceContextProviderDelegate;
        Class<ServiceContextManager> clazz = ServiceContextManager.class;
        synchronized (ServiceContextManager.class) {
            if (serviceContextProviderDelegate != null) return serviceContextProviderDelegate;
            serviceContextProviderDelegate = ServiceContextManager.loadDefaultServiceProvider();
            // ** MonitorExit[var0] (shouldn't be in output)
            return serviceContextProviderDelegate;
        }
    }
}

